/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __CELL_FACE_TRACKER_H__
#define __CELL_FACE_TRACKER_H__

//#define FOR_DEBUG 1

#include <cell/face.h>
#include <cell/spurs.h>

//////////////////////////////////////////////////////////////////////
// public 
//////////////////////////////////////////////////////////////////////

//CELL_FACE_TRACKER_STATUS 
#define CELL_FACE_TRACKER_STATUS_NOTTRACKING 0
#define CELL_FACE_TRACKER_STATUS_TRACKING    1
#define CELL_FACE_TRACKER_STATUS_LOST        2

//CELL_FACE_TRACKER_ERROR
#define CELL_FACE_TRACKER_OK                      CELL_OK
#define CELL_FACE_TRACKER_ERROR_BASE              0x80140940
#define CELL_FACE_TRACKER_ERROR_INVALID_WORKAREA  0x80140941
#define CELL_FACE_TRACKER_ERROR_WORKAREA_ALIGN    0x80140942
#define CELL_FACE_TRACKER_ERROR_ROWSTRIDE_ALIGN   0x80140943
#define CELL_FACE_TRACKER_ERROR_SHORT_WORKSIZE    0x80140944
#define CELL_FACE_TRACKER_ERROR_IMAGE_WIDTH_LIMIT 0x80140945
#define CELL_FACE_TRACKER_ERROR_INVALID_PARAM     0x80140946
#define CELL_FACE_TRACKER_ERROR_FACEID_FULL       0x80140947
#define CELL_FACE_TRACKER_ERROR_FACEID_NOT_EXIST  0x80140948
#define CELL_FACE_TRACKER_ERROR_NOT_INITIALIZED   0x80140949
#define CELL_FACE_TRACKER_ERROR_INVALID_TIMING    0x8014094a
#define CELL_FACE_TRACKER_ERROR_ALREADY_INITIALIZED 0x8014094b

#define CELL_FACE_TRACKER_IMG_WIDTH_MAX 2048
#define CELL_FACE_TRACKER_IMG_HEIGHT_MAX 4096
#define CELL_FACE_TRACKER_DETECTION_INTERVAL_MAX 600

#define CELL_FACE_TRACKER_ALIGN 128

#define CELL_FACE_TRACKER_RESULT_ALIGN 16
//FaceTrackingResult Structure
typedef struct CellFaceTrackerResult{
	int status;
	int id;
	float posX;
	float posY;
	float score;
}CellFaceTrackerResult;


#ifdef __cplusplus
extern "C" {
#endif
int cellFaceTrackerGetWorkingMemorySize(
	int *worksize, int imageWidth, int imageHeight, int imageRowstride, int maxTrackingNum);
int cellFaceTrackerInitialize(
	const void *workingArea, int worksize,
	const CellSpurs2 *spurs,
	int imageWidth, int imageHeight, int imageRowstride, int maxTrackingNum,
	int faceDetectionInterval);
int cellFaceTrackerFinalize(void);

int cellFaceTrackerUpdate(const unsigned char *imageData);
int cellFaceTrackerGetResult(int id, CellFaceTrackerResult *result);

//Callback
typedef void (*CellFaceTrackerCallbackFunc)(const CellFaceFeature2 *feature, const void *data);
int cellFaceTrackerRegisterCallback(CellFaceTrackerCallbackFunc func);

//Start / Stop Tracking
int cellFaceTrackerStartTracking(int id, const CellFaceFeature2 *feature);
int cellFaceTrackerStopTracking(int id);
int cellFaceTrackerReset(void);

#ifdef __cplusplus
}
#endif

#endif // __CELL_FACE_TRACKER_H__
