/*   SCE CONFIDENTIAL                                       */
/*   PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#ifndef __CELL_DBG_RSX_ENUM_H__
#define __CELL_DBG_RSX_ENUM_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	/*	Constants	*/
	typedef enum {
		CELL_DBG_RSX_FALSE	= (0),
		CELL_DBG_RSX_TRUE	= (1),
	};

	// Debug Cursor Magnification
	typedef enum {
		CELL_DBG_RSX_CURSOR_MAGNIFICATION_FACTOR_1X = 1, // x1
		CELL_DBG_RSX_CURSOR_MAGNIFICATION_FACTOR_2X, // x2
		CELL_DBG_RSX_CURSOR_MAGNIFICATION_FACTOR_4X, // x4
	};

	// Interrupt Error Status ID
	typedef enum {
		CELL_DBG_RSX_INTERRUPT_ERROR_STATUS_ID_FIFO = 1,
		CELL_DBG_RSX_INTERRUPT_ERROR_STATUS_ID_IOIF = (1<<1),
		CELL_DBG_RSX_INTERRUPT_ERROR_STATUS_ID_GRAPHICS = (1<<2),
		CELL_DBG_RSX_INTERRUPT_ERROR_STATUS_ID_MISC = (1<<3)
	};

	// Interrupt Fifo Error Status ID
	typedef enum {
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_METHOD = 1,
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_CALL = (1<<1),
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_RETURN = (1<<2),
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_COMMAND = (1<<3),
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_PROTECTION = (1<<4),
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_LABEL_BUSY = (1<<5),
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_LABEL_ERROR = (1<<6),
		CELL_DBG_RSX_INTERRUPT_FIFO_ERROR_STATUS_ID_LABEL_TIMEOUT = (1<<7)
	};

	// Interrupt IOIF Error Status ID
	typedef enum {
		CELL_DBG_RSX_INTERRUPT_IOIF_ERROR_STATUS_ID_RSX_MASTER = 1
	};

	// Interrupt Graphics Error Status ID
	typedef enum {
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_NOTIFY = 1,
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_METHOD_DATA = (1<<1),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_METHOD_ADDR = (1<<2),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_RANGE2D = (1<<3),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_COLOR_SURFACE = (1<<4),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_DEPTH_SURFACE = (1<<5),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_TRANSFER_DATA_READ = (1<<6),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_TRANSFER_DATA_WRITE = (1<<7),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_SURFACE_2D = (1<<8),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_STATE = (1<<9),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_METHOD_2D = (1<<10),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_VERTEX_ACCESS = (1<<11),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_IDX = (1<<12),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_BEGIN_END = (1<<13),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_TEXTURE_LOCAL = (1<<14),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_TEXTURE_MAIN = (1<<15),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_ZCULL = (1<<16),
		CELL_DBG_RSX_INTERRUPT_GRAPHICS_ERROR_STATUS_ID_SIP = (1<<17)
	};

	// Interrupt MISC Error Status ID
	typedef enum {
	    CELL_DBG_RSX_INTERRUPT_MISC_ERROR_STATUS_ID_DUMP = 1,
	    CELL_DBG_RSX_INTERRUPT_MISC_ERROR_STATUS_ID_SYSTEM_OVERLAY = (1<<1),
	};


	// Max Size of Fifo Cache
	typedef enum {
		CELL_DBG_RSX_FIFO_CACHE_METHOD_SIZE	= 512
	};

	// Method Type of Fifo Cache
	typedef enum {
		CELL_DBG_RSX_FIFO_CACHE_METHOD_TYPE_INCREMENT	= 0,
		CELL_DBG_RSX_FIFO_CACHE_METHOD_TYPE_NONINCREMENT	= 1
	};


	// Max Size of Graphics Fifo
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_FIFO_SIZE = 8
	};

	// Method Type of Graphics Fifo
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_FIFO_METHOD_TYPE_DOUBLE_NONINCREMENT = 0,
		CELL_DBG_RSX_GRAPHICS_FIFO_METHOD_TYPE_DOUBLE_INCREMENT = 1,
		CELL_DBG_RSX_GRAPHICS_FIFO_METHOD_TYPE_SINGLE = 2,
		CELL_DBG_RSX_GRAPHICS_FIFO_METHOD_TYPE_CONTEXT_SWITCH = 3
	};


	// FIFO Error State ID
	typedef enum {
		CELL_DBG_RSX_FIFO_ERROR_STATE_ID_DMA_METHOD = 1,	// when method error
		CELL_DBG_RSX_FIFO_ERROR_STATE_ID_DMA_SUBROUTINE,	// when call or return error
		CELL_DBG_RSX_FIFO_ERROR_STATE_ID_DMA_CONTROL,		// when protection error
		CELL_DBG_RSX_FIFO_ERROR_STATE_ID_DMA_COMMAND,		// when command error
		CELL_DBG_RSX_FIFO_ERROR_STATE_ID_LABEL,				// when label error
		CELL_DBG_RSX_FIFO_ERROR_STATE_ID_CACHE_CONTROL,
		CELL_DBG_RSX_FIFO_ERROR_STATE_ID_LAST
	};


	// subroutine error on CELL_DBG_RSX_FIFO_ERROR_STATE_ID_DMA_SUBROUTINE
	typedef enum {
		CELL_DBG_RSX_FIFO_ERROR_STATE_DMA_SUBROUTINE_RETURN_ERROR = 0,
		CELL_DBG_RSX_FIFO_ERROR_STATE_DMA_SUBROUTINE_CALL_ERROR = 1,
	};

	// context id on CELL_DBG_RSX_FIFO_ERROR_STATE_ID_DMA_CONTROL
	typedef enum {
		CELL_DBG_RSX_FIFO_ERROR_STATE_DMA_CONTROL_CONTEXT_SYSTEM = 0,	// system software
		CELL_DBG_RSX_FIFO_ERROR_STATE_DMA_CONTROL_CONTEXT_GAME = 1,		// game application
	};

	// flag on CELL_DBG_RSX_FIFO_ERROR_STATE_ID_LABEL
	typedef enum {
		CELL_DBG_RSX_FIFO_ERROR_STATE_LABEL_FLAG_INVALID = 0,
		CELL_DBG_RSX_FIFO_ERROR_STATE_LABEL_FLAG_VALID = 1,
	};
	// location on CELL_DBG_RSX_FIFO_ERROR_STATE_ID_LABEL
	typedef enum {
		CELL_DBG_RSX_FIFO_ERROR_STATE_LABEL_LOCATION_LOCAL_GLOBAL = 0,
		CELL_DBG_RSX_FIFO_RRORR_STATE_LABEL_LOCATION_LOCAL_SYSTEM = 1, // It's a TYPO in SDK270.
		CELL_DBG_RSX_FIFO_ERROR_STATE_LABEL_LOCATION_LOCAL_SYSTEM = 1,
		CELL_DBG_RSX_FIFO_ERROR_STATE_LABEL_LOCATION_LOCAL_GAME = 2,
	};



	// IOIF Error State ID
	typedef enum {
		CELL_DBG_RSX_IOIF_ERROR_STATE_ID_RSX_MASTER = 1,	// when rsx master error
		CELL_DBG_RSX_IOIF_ERROR_STATE_ID_LAST
	};

	// IOIF_ERROR_STATE_RSX_MASTER_MODE
	typedef enum {
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_MODE_WRITE = 0,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_MODE_READ = 1,
	};

	// IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR
	typedef enum {
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_HOST = 1,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_FRONTEND,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_FB,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_TEXTURE_CACHE,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_ZROP_READ,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_ZROP_WRITE,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_CROP_READ,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_CROP_WRITE,
		CELL_DBG_RSX_IOIF_ERROR_STATE_RSX_MASTER_REQUESTOR_OTHER = 0xff,
	};

	// Graphics Error State ID
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_LAUNCH_CHECK = 1,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_TRAPPED_ADDRESS_DATA,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_COLOR_SURFACE_VIOLATION,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_COLOR_SURFACE_LIMIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_DEPTH_SURFACE_VIOLATION,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_DEPTH_SURFACE_LIMIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_TRANSFER_DATA_READ,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_TRANSFER_DATA_WRITE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_GRAPHICS_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_FRONTEND_INDEX_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_GEOMETRY_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_SETUP_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_RASTER_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_ZCULL_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_PRE_SHADER_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_BASE_SHADER_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_RESERVED_0,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_RESERVED_1,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_RESERVED_2,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_RESERVED_3,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_TEXTURE_CACHE_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_ROP_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_2D_UNIT,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_ID_LAST
	};

	// Surface Violation Mode
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_DSTPITCH = (1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_DSTLIMIT = (1<<1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_DSTOVERLOW = (1<<2),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_DSTMEMSIZE = (1<<3),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_DSTTILED = (1<<4)
	};

	typedef enum {
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_SRCPITCH = (1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_SRCLIMIT = (1<<1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_SRCOVERLOW = (1<<2),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_SRCMEMSIZE = (1<<3),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_SRCTILED = (1<<4),
	};

	typedef enum{
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_SWIZZLEX = (1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_MODE_SWIZZLEY = (1<<1),
	};

	// Surface Violation Ropmode
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z32_C128 = 1,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z32_C64,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z32_C32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z32_CPSEUDO32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z32_C16,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z32_C32_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z16_C32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z16_CPSEUDO32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z16_C16,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z16_CPSEUDO32_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_Z16_C16_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_ZNULL_C8,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_ZNULL_C8_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2D32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2DPSEUDO32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2D16,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2D8,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2D32_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2DPSEUDO32_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2D16_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_2D8_SWIZZLE,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_CLEAR32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_CLEAR16,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_BLT32,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_BLT16,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_ROPMODE_BLT8
	};

	// Surface Violation Tilemode
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_TILEMODE_NULL = 0,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_TILEMODE_LINEAR = 1,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_SURFACE_VIOLATION_TILEMODE_TILED = 2,
	};

	// Graphics Unit State
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_GRAPHICS_UNIT_IDLE = 0,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_GRAPHICS_UNIT_BUSY = 1,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_GRAPHICS_UNIT_QUIESCENT = 2,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_GRAPHICS_UNIT_STALLED = 3,
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_GRAPHICS_UNIT_HALTED = 4,
	};
	
	// Launch Check 1
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_ANISO_3D                  = (1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_ANISO_CONVOLUTION         = (1 << 1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_GAMMA8                    = (1 << 2),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_SHADER16                  = (1 << 3),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_IMAGE_TEX_BORDER          = (1 << 4),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_IMAGE_TEX_WRAP_MIRROR     = (1 << 5),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_IMAGE_TEX_FORMAT          = (1 << 6),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_IMAGE_TEX_ALIGN           = (1 << 7),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_IMAGE_TEX_HEIGHT          = (1 << 8),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_DXT_COLORKEY              = (1 << 9),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_COMBINER_DEST_ALPHA_COLOR = (1 << 10),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_ZCULL_SURFACE_INIT        = (1 << 11),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_CLIPID_SURFACE_INIT       = (1 << 12),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_SIGNED_BLEND_FBFORMAT     = (1 << 18),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_BLEND_YFORMAT             = (1 << 19),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_FLOAT_SURFACE             = (1 << 21),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_FLOAT_CLAMP               = (1 << 22),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_FLOAT_BOX                 = (1 << 23),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_FLOAT_KILL                = (1 << 24),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_FLOAT_REMAP               = (1 << 25),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_FLOAT_HEMI                = (1 << 26),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_ANISO_FLOAT               = (1 << 27),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK1_INVALID_FORMAT            = (1 << 28),
	};

	// Launch Check 2
	typedef enum{
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_CONVOLUTION_3D   = (1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_WRAP_MIRROR_PO2  = (1 << 1),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SWIZ_PO2         = (1 << 2),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SIZE_3D          = (1 << 3),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_MET              = (1 << 4),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SWIZ_BORDER_SIZE = (1 << 5),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SWIZ_ALIGNMENT   = (1 << 7),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_FLOAT_TEX        = (1 << 8),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_DXT              = (1 << 9),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_FIELD_MODE       = (1 << 10),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_ANISO            = (1 << 11),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_DXT_YUYV         = (1 << 12),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_CUBEMAP          = (1 << 13),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_REMAP_STRAIGHT   = (1 << 15),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_REMAP_16BIT      = (1 << 17),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_GAMMA            = (1 << 18),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_INVALID_FORMAT   = (1 << 19),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_FLOAT_BLEND      = (1 << 20),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_FLOAT_SURFACE    = (1 << 21),
		CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_MRT              = (1 << 22),
	};
	
	// Graphics Bundle State ID
	// same macro name as gcm_methods.h
	typedef enum {
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POLYGON_STIPPLE = 1,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POLYGON_STIPPLE_PATTERN,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_LINE_STIPPLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_LINE_STIPPLE_PATTERN,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_WINDOW_OFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SHADER_PROGRAM,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_COLOR_TARGET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_FOG_PARAMS,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POINT_SIZE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SEMAPHORE_OFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_CLIP_HORIZONTAL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_CLIP_VERTICAL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_ANTI_ALIASING_CONTROL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BLEND_EQUATION,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BLEND_FUNC_SFACTOR,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BLEND_FUNC_DFACTOR,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BLEND_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BLEND_ENABLE_MRT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_LOGIC_OP,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_LOGIC_OP_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BLEND_COLOR,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BLEND_COLOR2,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_COLOR_CLEAR_VALUE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_STENCIL_FUNC,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_STENCIL_FUNC_REF,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_STENCIL_FUNC_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_STENCIL_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_STENCIL_OP_FAIL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_STENCIL_OP_ZFAIL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_STENCIL_OP_ZPASS,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_USER_CLIP_PLANE_CONTROL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VIEWPORT_HORIZONTAL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VIEWPORT_VERTICAL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SCISSOR_HORIZONTAL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SCISSOR_VERTICAL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_ZSTENCIL_CLEAR_VALUE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CLIP_MIN,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CLIP_MAX,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POLYGON_OFFSET_SCALE_FACTOR,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POLYGON_OFFSET_BIAS,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_RESTART_INDEX_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_RESTART_INDEX,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CYLINDRICAL_WRAP,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CYLINDRICAL_WRAP1,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SHADER_CONTROL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_REDUCE_DST_COLOR,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SHADER_WINDOW,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_DEPTH_BOUNDS_MIN,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_DEPTH_BOUNDS_MAX,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_ATTRIB_INPUT_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_ATTRIB_OUTPUT_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEX_COORD_CONTROL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_DATA_BASE_OFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_DATA_BASE_INDEX,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TRANSFORM_TIMEOUT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SHADER_PACKER,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TRANSFORM_BRANCH_BITS,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_COLOR_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TRANSFORM_PROGRAM_LOAD,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TRANSFORM_CONSTANT_LOAD,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_OFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_FORMAT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_ADDRESS,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_CONTROL0,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_CONTROL1,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_CONTROL2,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_CONTROL3,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_FILTER,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_IMAGE_RECT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TEXTURE_BORDER_COLOR,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_OFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_FORMAT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_ADDRESS,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_CONTROL0,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_CONTROL3,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_FILTER,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_IMAGE_RECT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_TEXTURE_BORDER_COLOR,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_ANISO_SPREAD,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_ALPHA_FUNC,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_ALPHA_REF,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_ALPHA_TEST_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_DEPTH_TEST_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_DEPTH_FUNC,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_DITHER_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_DEPTH_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_TEST_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TWO_SIDED_STENCIL_TEST_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_FUNC,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_FUNC_REF,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_FUNC_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_MASK,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_OP_FAIL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_OP_ZFAIL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_STENCIL_OP_ZPASS,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SHADE_MODE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POINT_SPRITE_CONTROL,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_FOG_MODE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TRANSFORM_PROGRAM_START,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_FORMAT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_COLOR_AOFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_COLOR_BOFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_COLOR_COFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_COLOR_DOFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_PITCH_A,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_PITCH_B,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_PITCH_C,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_PITCH_D,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_ZETA_OFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_SURFACE_PITCH_Z,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_COLOR_MASK_MRT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_DATA_ARRAY_FORMAT,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_VERTEX_DATA_ARRAY_OFFSET,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CONTEXT_DMA_COLOR_A,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CONTEXT_DMA_COLOR_B,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CONTEXT_DMA_COLOR_C,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CONTEXT_DMA_COLOR_D,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CONTEXT_DMA_ZETA,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_FRONT_FACE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CULL_FACE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CULL_FACE_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_LINE_WIDTH,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_LINE_SMOOTH_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POLY_OFFSET_FILL_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POLY_OFFSET_LINE_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_POLY_SMOOTH_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_FRONT_POLYGON_MODE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_BACK_POLYGON_MODE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_TWO_SIDE_LIGHT_EN,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_CONTROL0,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_DEPTH_BOUNDS_TEST_ENABLE,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_FREQUENCY_DIVIDER_OPERATION,
		CELL_DBG_RSX_GRAPHICS_BUNDLE_STATE_ID_LAST
	};

	//	Launch Check State
	typedef enum{

		CELL_DBG_RSX_LAUNCH_CHECK_STATE_NO_ERROR = (0x00) ,

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_CONVOLUTION_3D
		CELL_DBG_RSX_LAUNCH_CHECK_CONVOLUTION_3D_ERROR = (0x01) ,

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_WRAP_MIRROR_PO2
		CELL_DBG_RSX_LAUNCH_CHECK_WRAP_MIRROR_PO2_ERROR_WIDTH  = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_WRAP_MIRROR_PO2_ERROR_HEIGHT = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_WRAP_MIRROR_PO2_ERROR_DEPTH  = (0x03),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SWIZ_PO2
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_PO2_ERROR_WIDTH  = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_PO2_ERROR_HEIGHT = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_PO2_ERROR_DEPTH  = (0x03),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SIZE_3D
		CELL_DBG_RSX_LAUNCH_CHECK_SIZE_3D_ERROR_WIDTH  = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_SIZE_3D_ERROR_HEIGHT = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_SIZE_3D_ERROR_DEPTH  = (0x03),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SWIZ_BORDER_SIZE
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_BORDER_SIZE_ERROR_WIDTH     = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_BORDER_SIZE_ERROR_HEIGHT    = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_BORDER_SIZE_ERROR_WIDTH_3D  = (0x03),
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_BORDER_SIZE_ERROR_HEIGHT_3D = (0x04),
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_BORDER_SIZE_ERROR_DEPTH_3D  = (0x05),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_SWIZ_ALIGNMENT
		CELL_DBG_RSX_LAUNCH_CHECK_SWIZ_ALIGNMENT_ERROR = (0x01),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_FLOAT_TEX
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_TEX_ERROR_MIN_FILTER = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_TEX_ERROR_MAG_FILTER = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_TEX_ERROR_ALPHA_KILL = (0x03),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_ANISO
		CELL_DBG_RSX_LAUNCH_CHECK_ANISO_ERROR_CONVOLUTION_MIN               = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_ANISO_ERROR_CONVOLUTION_MAG               = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_ANISO_ERROR_W32_Z32_Y32_X32_FLOAT_TEXTURE = (0x03),
		CELL_DBG_RSX_LAUNCH_CHECK_ANISO_ERROR_X32_FLOAT_TEXTURE             = (0x04),
		CELL_DBG_RSX_LAUNCH_CHECK_ANISO_ERROR_3D_TEXTURE                    = (0x05),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_CUBEMAP
		CELL_DBG_RSX_LAUNCH_CHECK_CUBEMAP_ERROR_TEXTURE_DIMENSION = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_CUBEMAP_ERROR_TEXTURE_SIZE      = (0x02),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_REMAP_STRAIGHT
		CELL_DBG_RSX_LAUNCH_CHECK_REMAP_STRAIGHT_ERROR_INPUT_A = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_REMAP_STRAIGHT_ERROR_INPUT_R = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_REMAP_STRAIGHT_ERROR_INPUT_G = (0x03),
		CELL_DBG_RSX_LAUNCH_CHECK_REMAP_STRAIGHT_ERROR_INPUT_B = (0x04),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_REMAP_16BIT
		CELL_DBG_RSX_LAUNCH_CHECK_REMAP_16BIT_ERROR = (0x01),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_GAMMA
		CELL_DBG_RSX_LAUNCH_CHECK_GAMMA_ERROR = (0x01),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_INVALID_FORMAT
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_B8_DEPTH_TEST			= (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_B8_STENCIL_TEST			= (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_B8_DEPTH_BOUNDS_TEST		= (0x03),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_B8_SWIZZLE				= (0x04),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_B8_NON_SIGNED_BLENDING	= (0x05),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_G8B8_DEPTH_TEST			= (0x06),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_G8B8_STENCIL_TEST		= (0x07),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_G8B8_DEPTH_BOUNDS_TEST	= (0x08),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_G8B8_SWIZZLE				= (0x09),
		CELL_DBG_RSX_LAUNCH_CHECK_INVALID_FORMAT_ERROR_G8B8_NON_SIGNED_BLENDING	= (0x0a),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_FLOAT_BLEND
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_BLEND_ERROR_X1R5G5B5_Z1R5G5B5	= (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_BLEND_ERROR_X1R5G5B5_O1R5G5B5	= (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_BLEND_ERROR_R5G6B5				= (0x03),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_BLEND_ERROR_F_W16Z16Y16X16		= (0x04),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_FLOAT_SURFACE
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_ANTIALIASING_CONTROL = (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_ANTIALIASING_SURFACE = (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_ALPHA_TO_COVERAGE    = (0x03),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_ALPHA_TO_ONE         = (0x04),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_LINESMOOTH           = (0x05),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_POLYSMOOTH           = (0x06),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_SWIZZLE              = (0x07),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_ALPHA_TEST           = (0x08),
		CELL_DBG_RSX_LAUNCH_CHECK_FLOAT_SURFACE_ERROR_BLENDING             = (0x09),

		//	for CELL_DBG_RSX_GRAPHICS_ERROR_STATE_LAUNCH_CHECK2_MRT
		CELL_DBG_RSX_LAUNCH_CHECK_MRT_ERROR_ALPHA_TEST					= (0x01),
		CELL_DBG_RSX_LAUNCH_CHECK_MRT_ERROR_ALPHA_TO_COVERAGE			= (0x02),
		CELL_DBG_RSX_LAUNCH_CHECK_MRT_ERROR_REGISTER_COUNT_LESS_THAN_3  = (0x03),
		CELL_DBG_RSX_LAUNCH_CHECK_MRT_ERROR_REGISTER_COUNT_LESS_THAN_4  = (0x04),
		CELL_DBG_RSX_LAUNCH_CHECK_MRT_ERROR_REGISTER_COUNT_LESS_THAN_5  = (0x05),
		
	};

	//	Method Check State
	typedef enum {
		
		CELL_DBG_RSX_METHOD_CHECK_NO_ERROR 			 = (0x00),
		CELL_DBG_RSX_METHOD_CHECK_OUT_OF_RANGE_ERROR = (0x01),
		CELL_DBG_RSX_METHOD_CHECK_COMBINATION_ERROR  = (0x02),
	};

	//	Method Check Combination Error State
	typedef enum {
		
		CELL_DBG_RSX_METHOD_CHECK_COMBINATION_NO_ERROR									= (0x00),
		CELL_DBG_RSX_METHOD_CHECK_SURFACE_COLOR_TARGET									= (0x01),
		CELL_DBG_RSX_METHOD_CHECK_VERTEX_DATA_ARRAY_FORMAT								= (0x02),
		CELL_DBG_RSX_METHOD_CHECK_TEXTURE_FORMAT_UNNORMALIZED_WITH_CUBEMAP_OR_MIPMAP	= (0x03),
		CELL_DBG_RSX_METHOD_CHECK_TEXTURE_FORMAT_DEPTH_WITH_3D							= (0x04),
		CELL_DBG_RSX_METHOD_CHECK_SURFACE_FORMAT_WIDTH_HEIGHT							= (0x05),
		CELL_DBG_RSX_METHOD_CHECK_SURFACE_FORMAT_SWIZZLE_WITH_AA						= (0x06),
		CELL_DBG_RSX_METHOD_CHECK_SURFACE_FORMAT_SWIZZLE_WITH_MIXED_32_16				= (0x07),
		CELL_DBG_RSX_METHOD_CHECK_SURFACE_FORMAT_FLOAT_COLOR_WITH_Z16					= (0x08),
	};

	//	Method Check Func Id
	typedef enum {
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_OPEN_METHOD = 0,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_NOTIFY ,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_PM_TRIGGER,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_CLIP_HORIZONTAL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_CLIP_VERTICAL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_FORMAT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_PITCH_A,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_COLOR_AOFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_ZETA_OFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_COLOR_BOFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_PITCH_B,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_COLOR_TARGET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_PITCH_Z,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_INVALIDATE_ZCULL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_PITCH_C,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_PITCH_D,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_COLOR_COFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SURFACE_COLOR_DOFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_WINDOW_OFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_DITHER_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ALPHA_TEST_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ALPHA_FUNC,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ALPHA_REF,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BLEND_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BLEND_FUNC_SFACTOR,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BLEND_FUNC_DFACTOR,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BLEND_EQUATION,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_COLOR_MASK,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_STENCIL_TEST_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_STENCIL_FUNC,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_STENCIL_FUNC_REF,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_STENCIL_OP_FAIL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_STENCIL_OP_ZFAIL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_STENCIL_OP_ZPASS,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TWO_SIDED_STENCIL_TEST_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BACK_STENCIL_FUNC,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BACK_STENCIL_OP_FAIL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BACK_STENCIL_OP_ZFAIL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BACK_STENCIL_OP_ZPASS,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SHADE_MODE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BLEND_ENABLE_MRT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_LOGIC_OP_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_LOGIC_OP,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_DEPTH_BOUNDS_TEST_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_CONTROL0,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_LINE_SMOOTH_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ANISO_SPREAD,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SCISSOR_HORIZONTAL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SCISSOR_VERTICAL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_FOG_MODE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_FOG_PARAMS,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VERTEX_TEXTURE_OFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VERTEX_TEXTURE_FORMAT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VERTEX_TEXTURE_ADDRESS,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VERTEX_TEXTURE_IMAGE_RECT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VIEWPORT_HORIZONTAL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VIEWPORT_VERTICAL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_POLY_OFFSET_LINE_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_POLY_OFFSET_FILL_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_DEPTH_FUNC,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_DEPTH_MASK,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_DEPTH_TEST_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEXTURE_CONTROL2,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEX_COORD_CONTROL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TWO_SIDE_LIGHT_EN,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_CLEAR_ZCULL_SURFACE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_USER_CLIP_PLANE_CONTROL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VERTEX_DATA_ARRAY_OFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_INVALIDATE_VERTEX_CACHE_FILE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_INVALIDATE_VERTEX_FILE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_VERTEX_DATA_ARRAY_FORMAT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_CLEAR_REPORT_VALUE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ZPASS_PIXEL_COUNT_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_GET_REPORT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ZCULL_STATS_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BEGIN_END,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_INDEX_ARRAY_DMA,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_FRONT_POLYGON_MODE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_BACK_POLYGON_MODE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_CULL_FACE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_FRONT_FACE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_POLY_SMOOTH_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_CULL_FACE_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEXTURE_FORMAT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEXTURE_ADDRESS,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEXTURE_CONTROL0,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEXTURE_CONTROL1,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEXTURE_FILTER,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TEXTURE_IMAGE_RECT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SHADER_CONTROL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SEMAPHORE_OFFSET,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ZMIN_MAX_CONTROL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ANTI_ALIASING_CONTROL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SHADER_WINDOW,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_RENDER_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TRANSFORM_PROGRAM_LOAD,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TRANSFORM_PROGRAM_START,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_ZCULL_CONTROL0,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_SCULL_CONTROL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_POINT_PARAMS_ENABLE,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_POINT_SPRITE_CONTROL,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TRANSFORM_TIMEOUT,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_SET_TRANSFORM_CONSTANT_LOAD,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_INVALIDATE_L2,
		CELL_DBG_RSX_METHOD_CHECK_FUNC_ID_LAST 
	};

	//	Method Check Argument Id
	typedef enum {

		CELL_DBG_RSX_METHOD_ARG_ID_NONE ,
		CELL_DBG_RSX_METHOD_ARG_ID_TYPE ,
		CELL_DBG_RSX_METHOD_ARG_ID_VALUE ,
		CELL_DBG_RSX_METHOD_ARG_ID_DATA ,
		CELL_DBG_RSX_METHOD_ARG_ID_X ,
		CELL_DBG_RSX_METHOD_ARG_ID_WIDTH ,
		CELL_DBG_RSX_METHOD_ARG_ID_Y ,
		CELL_DBG_RSX_METHOD_ARG_ID_HEIGHT ,
		CELL_DBG_RSX_METHOD_ARG_ID_COLOR ,
		CELL_DBG_RSX_METHOD_ARG_ID_ZETA ,
		CELL_DBG_RSX_METHOD_ARG_ID_MRT ,
		CELL_DBG_RSX_METHOD_ARG_ID_ZDIR ,
		CELL_DBG_RSX_METHOD_ARG_ID_ZFORMAT ,
		CELL_DBG_RSX_METHOD_ARG_ID_SFUNC ,
		CELL_DBG_RSX_METHOD_ARG_ID_MIPMAPROUNDING ,
		CELL_DBG_RSX_METHOD_ARG_ID_Z_FORMAT ,
		CELL_DBG_RSX_METHOD_ARG_ID_DEFAULTPARTIAL ,
		CELL_DBG_RSX_METHOD_ARG_ID_TEXTUREPERSPECTIVE ,
		CELL_DBG_RSX_METHOD_ARG_ID_COLORSPACECONVERT ,
		CELL_DBG_RSX_METHOD_ARG_ID_METCONTROL ,
		CELL_DBG_RSX_METHOD_ARG_ID_RMODE ,
		CELL_DBG_RSX_METHOD_ARG_ID_ALPHA ,
		CELL_DBG_RSX_METHOD_ARG_ID_RED ,
		CELL_DBG_RSX_METHOD_ARG_ID_GREEN ,
		CELL_DBG_RSX_METHOD_ARG_ID_BLUE ,
		CELL_DBG_RSX_METHOD_ARG_ID_REF ,
		CELL_DBG_RSX_METHOD_ARG_ID_PLANE0 ,
		CELL_DBG_RSX_METHOD_ARG_ID_PLANE1 ,
		CELL_DBG_RSX_METHOD_ARG_ID_PLANE2 ,
		CELL_DBG_RSX_METHOD_ARG_ID_PLANE3 ,
		CELL_DBG_RSX_METHOD_ARG_ID_PLANE4 ,
		CELL_DBG_RSX_METHOD_ARG_ID_PLANE5 ,
		CELL_DBG_RSX_METHOD_ARG_ID_OFFSET ,
		CELL_DBG_RSX_METHOD_ARG_ID_SIZE ,
		CELL_DBG_RSX_METHOD_ARG_ID_CONTEXT ,
		CELL_DBG_RSX_METHOD_ARG_ID_DIMENTIONALITY ,
		CELL_DBG_RSX_METHOD_ARG_ID_MIPMAPLEVELS ,
		CELL_DBG_RSX_METHOD_ARG_ID_U ,
		CELL_DBG_RSX_METHOD_ARG_ID_V ,
		CELL_DBG_RSX_METHOD_ARG_ID_UNSIGNEDREMAP ,
		CELL_DBG_RSX_METHOD_ARG_ID_P ,
		CELL_DBG_RSX_METHOD_ARG_ID_SIGNEDREMAP ,
		CELL_DBG_RSX_METHOD_ARG_ID_SHADOWZFUNC ,
		CELL_DBG_RSX_METHOD_ARG_ID_SHADERREMAPORDER ,
		CELL_DBG_RSX_METHOD_ARG_ID_SHADERREMAPOUTPUTA ,
		CELL_DBG_RSX_METHOD_ARG_ID_SHADERREMAPOUTPUTR ,
		CELL_DBG_RSX_METHOD_ARG_ID_SHADERREMAPOUTPUTG ,
		CELL_DBG_RSX_METHOD_ARG_ID_SHADERREMAPOUTPUTB ,
		CELL_DBG_RSX_METHOD_ARG_ID_CONVOLUTIONKERNEL ,
		CELL_DBG_RSX_METHOD_ARG_ID_MIN ,
		CELL_DBG_RSX_METHOD_ARG_ID_MAG ,
		CELL_DBG_RSX_METHOD_ARG_ID_SPACINGSELECT ,
		CELL_DBG_RSX_METHOD_ARG_ID_REDUCESAMPLES ,
		CELL_DBG_RSX_METHOD_ARG_ID_HSPACINGSELECT ,
		CELL_DBG_RSX_METHOD_ARG_ID_HREDUCESAMPLES ,
		CELL_DBG_RSX_METHOD_ARG_ID_VSPACINGSELECT ,
		CELL_DBG_RSX_METHOD_ARG_ID_VREDUCESAMPLES ,
		CELL_DBG_RSX_METHOD_ARG_ID_FLIP ,
		CELL_DBG_RSX_METHOD_ARG_ID_CULLNEARFAREN ,
		CELL_DBG_RSX_METHOD_ARG_ID_ZCLAMPEN ,
		CELL_DBG_RSX_METHOD_ARG_ID_CULLIGNOREW ,
		CELL_DBG_RSX_METHOD_ARG_ID_ENABLE ,
		CELL_DBG_RSX_METHOD_ARG_ID_ALPHATOCOVERAGE ,
		CELL_DBG_RSX_METHOD_ARG_ID_ALPHATOONE ,
		CELL_DBG_RSX_METHOD_ARG_ID_ANTIALIASING ,
		CELL_DBG_RSX_METHOD_ARG_ID_XMIN ,
		CELL_DBG_RSX_METHOD_ARG_ID_XMAX ,
		CELL_DBG_RSX_METHOD_ARG_ID_YMIN ,
		CELL_DBG_RSX_METHOD_ARG_ID_YMAX ,
		CELL_DBG_RSX_METHOD_ARG_ID_REGISTERCOUNT ,
		CELL_DBG_RSX_METHOD_ARG_ID_REMAPNAN ,
		CELL_DBG_RSX_METHOD_ARG_ID_CONTROLSUFFIX ,
		CELL_DBG_RSX_METHOD_ARG_ID_ORIGIN ,
		CELL_DBG_RSX_METHOD_ARG_ID_PIXELCENTERS ,
		CELL_DBG_RSX_METHOD_ARG_ID_MODE ,
		CELL_DBG_RSX_METHOD_ARG_ID_ZERO ,
		CELL_DBG_RSX_METHOD_ARG_ID_PROGLDPTR ,
		CELL_DBG_RSX_METHOD_ARG_ID_CONSTLDPTR ,
		CELL_DBG_RSX_METHOD_ARG_ID_TWOD ,
		CELL_DBG_RSX_METHOD_ARG_ID_CENTROID ,
		CELL_DBG_RSX_METHOD_ARG_ID_FLAT ,
		CELL_DBG_RSX_METHOD_ARG_ID_COUNT ,
		CELL_DBG_RSX_METHOD_ARG_ID_MAX ,
		CELL_DBG_RSX_METHOD_ARG_ID_LOCATIONS ,
		CELL_DBG_RSX_METHOD_ARG_ID_LAST

	};
	
	typedef enum {
		CELL_DBG_RSX_EXTRACT_TYPE_GRAPHICS_COMMAND = 0 ,
		CELL_DBG_RSX_EXTRACT_TYPE_NON_GRAPHICS_COMMAND ,
	};

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __CELL_DBG_RSX_ENUM_H__ */


