/*   SCE CONFIDENTIAL                                       */
/*   PlayStation(R)3 Programmer Tool Runtime Library 475.001 */
/*   Copyright (C) 2011 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#ifndef __BUNDLE_STATE_STRUCT_H__
#define __BUNDLE_STATE_STRUCT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	typedef struct CellDbgRsxBundleStatePolygonStipple
	{
		unsigned enable : 32;	//	Stipple polygon rendering
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePolygonStipple;

	//typedef struct CellDbgRsxBundleStatePolygonStipplePattern
	//{
	//		//	Currently this bundle state does not represent any usable information.
	//} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePolygonStipplePattern;

	typedef struct CellDbgRsxBundleStateLineStipple
	{
		unsigned enable : 32;	//	Stipple line rendering
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateLineStipple;

	typedef struct CellDbgRsxBundleStateLineStipplePattern
	{
		unsigned pattern : 16;	//	Stipple pattern in 16 bits
		unsigned factor  : 16;	//	Number of times to repeat stipple pattern (0 - 255)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateLineStipplePattern;

	typedef struct CellDbgRsxBundleStateWindowOffset
	{
		unsigned y : 16;	//	Window offset in the y direction (0 - 4095)
		unsigned x : 16;	//	Window offset in the x direction (0 - 4095)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateWindowOffset;

	typedef struct CellDbgRsxBundleStateShaderProgram
	{
		unsigned offset   : 26;	//	Fragment program offset(from the base address of main memory and of local memory)
		unsigned padding  : 4;
		unsigned location : 2;	//	Fragment program location
								//		0x1: Local memory
								//		0x2: Main memory

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateShaderProgram;

	typedef struct CellDbgRsxBundleStateSurfaceColorTarget
	{
		unsigned padding     : 27;
		unsigned colorTarget : 5;	//	Render target to use as the surface

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceColorTarget;

	typedef struct CellDbgRsxBundleStateFogParams
	{
		struct {
			unsigned value;	//	Bias(data[0]) and Scale(data[1]) for fog coordinates (32-bit float)
		} data[2];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateFogParams;

	typedef struct CellDbgRsxBundleStatePointSize
	{
		uint32_t data0;	//	Point diameter (float, 1 - 63)

	} __attribute__ ((aligned(4)))CellDbgRsxBundleStatePointSize;

	typedef struct CellDbgRsxBundleStateSemaphoreOffset
	{
		unsigned padding0 : 8;
		unsigned index    : 20;	//	Index of the destination to write to(Value specified to cellGcmSetWriteBackEndLabel() or cellGcmSetWriteTextureLabel())
		unsigned padding1 : 4;

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSemaphoreOffset;

	typedef struct CellDbgRsxBundleStateSurfaceClipHorizontal
	{
		unsigned width : 16;	//	Width of the render buffer
		unsigned x     : 16;	//	Window offset in the x direction

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceClipHorizontal;

	typedef struct CellDbgRsxBundleStateSurfaceClipVertical
	{
		unsigned height : 16;	//	Height of the render buffer
		unsigned y      : 16;	//	Window offset in the y direction

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceClipVertical;

	typedef struct CellDbgRsxBundleStateAntiAliasingControl
	{
		unsigned sampleMask      : 16;	//	Additional update mask (0 - 0xFFFF)
		unsigned padding         : 4;
		unsigned alphaToOne      : 4;	//	Setting alpha value as maximum value after calculating update mask for fragment
										//		CELL_GCM_FALSE: Alpha value is not set as the maximum
										//		CELL_GCM_TRUE: Alpha value is set as the maximum
		unsigned alphaToCoverage : 4;	//	Use of alpha value in calculating update mask for fragment
										//		CELL_GCM_FALSE: Alpha value is not used
										//		CELL_GCM_TRUE: Alpha value is used
		unsigned enable          : 4;	//	Antialiasing during multisampling
										//		CELL_GCM_FALSE: Disabled
										//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateAntiAliasingControl;

	typedef struct CellDbgRsxBundleStateBlendEquation
	{
		unsigned alpha : 16;	//	Blending equation for alpha component
		unsigned color : 16;	//	Blending equation for RGB components

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBlendEquation;

	typedef struct CellDbgRsxBundleStateBlendFuncSfactor
	{
		unsigned sfAlpha : 16;	//	Method of calculating the blending coefficient of the source alpha component
		unsigned sfColor : 16;	//	Method of calculating the blending coefficient of the source RGB components

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBlendFuncSfactor;

	typedef struct CellDbgRsxBundleStateBlendFuncDfactor
	{
		unsigned dfAlpha : 16;	//	Method of calculating the blending coefficient of the target alpha component
		unsigned dfColor : 16;	//	Method of calculating the blending coefficient of the target RGB components

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBlendFuncDfactor;

	typedef struct CellDbgRsxBundleStateBlendEnable
	{
		unsigned enable : 32;	//	Pixel blending
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBlendEnable;

	typedef struct CellDbgRsxBundleStateBlendEnableMrt
	{
		unsigned padding0 : 28;
		unsigned mrt3     : 1;	//	Pixel blending of render target 3
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled
		unsigned mrt2     : 1;	//	Pixel blending of render target 2
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled
		unsigned mrt1     : 1;	//	Pixel blending of render target 1
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled
		unsigned padding1 : 1;

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBlendEnableMrt;

	typedef struct CellDbgRsxBundleStateLogicOp
	{
		unsigned op : 32;	//	Symbol constant for selecting the logical operation

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateLogicOp;

	typedef struct CellDbgRsxBundleStateLogicOpEnable
	{
		unsigned enable : 32;	//	Pixel logical operation
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateLogicOpEnable;

	typedef struct CellDbgRsxBundleStateBlendColor
	{
		unsigned color : 32;	//	Constant to use in pixel blending
								//	(8 bits to RGBA, or 16 bits to RG)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBlendColor;

	typedef struct CellDbgRsxBundleStateBlendColor2
	{
		unsigned color : 32;	//	Constant to use in pixel blending
								//	(16 bits to BA)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBlendColor2;

	typedef struct CellDbgRsxBundleStateColorClearValue
	{
		unsigned color : 32;	//	Color value used to clear the color buffer (A8R8G8B8)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateColorClearValue;

	typedef struct CellDbgRsxBundleStateBackStencilFunc
	{
		unsigned func : 32;	//	Function to use in the stencil test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackStencilFunc;

	typedef struct CellDbgRsxBundleStateBackStencilFuncRef
	{
		unsigned ref : 32;	//	Stencil test reference value

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackStencilFuncRef;

	typedef struct CellDbgRsxBundleStateBackStencilFuncMask
	{
		unsigned mask : 32;	//	Stencil test mask value

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackStencilFuncMask;

	typedef struct CellDbgRsxBundleStateBackStencilMask
	{
		unsigned sm : 32;	//	Bit mask enabling/disabling writes to each bit of the stencil plane

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackStencilMask;

	typedef struct CellDbgRsxBundleStateBackStencilOpFail
	{
		unsigned fail : 32;	//	Stencil processing after failing the stencil test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackStencilOpFail;

	typedef struct CellDbgRsxBundleStateBackStencilOpZfail
	{
		unsigned depthFail : 32;	//	Stencil processing after failing the depth test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackStencilOpZfail;

	typedef struct CellDbgRsxBundleStateBackStencilOpZpass
	{
		unsigned depthPass : 32;	//	Stencil processing after passing both the stencil test and the depth test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackStencilOpZpass;

	typedef struct CellDbgRsxBundleStateUserClipPlaneControl
	{
		unsigned padding : 8;
		unsigned plane5  : 4;	//	Settings of clip plane 5
		unsigned plane4  : 4;	//	Settings of clip plane 4
		unsigned plane3  : 4;	//	Settings of clip plane 3
		unsigned plane2  : 4;	//	Settings of clip plane 2
		unsigned plane1  : 4;	//	Settings of clip plane 1
		unsigned plane0  : 4;	//	Settings of clip plane 0

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateUserClipPlaneControl;

	typedef struct CellDbgRsxBundleStateViewportHorizontal
	{
		unsigned width : 16;	//	Width of viewport
		unsigned x     : 16;	//	x coordinate of upper left corner of viewport

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateViewportHorizontal;

	typedef struct CellDbgRsxBundleStateViewportVertical
	{
		unsigned height : 16;	//	Height of viewport
		unsigned y      : 16;	//	y coordinate of upper left corner of viewport

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateViewportVertical;

	typedef struct CellDbgRsxBundleStateScissorHorizontal
	{
		unsigned width : 16;	//	Width of scissor box
		unsigned x     : 16;	//	x coordinate of upper left corner of scissor box

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateScissorHorizontal;

	typedef struct CellDbgRsxBundleStateScissorVertical
	{
		unsigned height : 16;	//	Height of scissor box
		unsigned y      : 16;	//	y coordinate of upper left corner of scissor box

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateScissorVertical;

	typedef struct CellDbgRsxBundleStateZstencilClearValue
	{
		unsigned value : 32;	//	Z value and stencil value used to clear the depth buffer

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateZstencilClearValue;

	typedef struct CellDbgRsxBundleStateClipMin
	{
		unsigned min : 32;	//	Z clip minimum (float)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateClipMin;

	typedef struct CellDbgRsxBundleStateClipMax
	{
		unsigned max : 32;	//	Z clip maximum (float)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateClipMax;

	typedef struct CellDbgRsxBundleStatePolygonOffsetScaleFactor
	{
		unsigned factor : 32;	//	Scale factor (float)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePolygonOffsetScaleFactor;

	typedef struct CellDbgRsxBundleStatePolygonOffsetBias
	{
		unsigned units : 32;	//	Bias value (float)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePolygonOffsetBias;

	typedef struct CellDbgRsxBundleStateRestartIndexEnable
	{
		unsigned padding : 31;
		unsigned enable  : 1;	//	Restart of primitive rendering from a vertex index
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateRestartIndexEnable;

	typedef struct CellDbgRsxBundleStateRestartIndex
	{
		unsigned index : 32;	//	Index to restart primitive building

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateRestartIndex;

	typedef struct CellDbgRsxBundleStateCylindricalWrap
	{
		unsigned data : 32;

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateCylindricalWrap;

	//typedef struct STRUCT_BUNDLE_STATE_ID_CYLINDRICAL_WRAP1
	//{
	//		//	Currently this bundle state does not represent any usable information.
	//}__attribute__ ((aligned(4))) STRUCT_BUNDLE_STATE_ID_CYLINDRICAL_WRAP1;

	typedef struct CellDbgRsxBundleStateShaderControl
	{
		unsigned registerCount : 8;	//	Number of registers
		unsigned padding0      : 8;
		unsigned controlTxp    : 1;	//	TXP demotion
									//		0x0: Disabled
									//		0x1: Enabled
		unsigned padding1      : 4;
		unsigned always_1      : 1;	//	Always 1
		unsigned padding2      : 2;
		unsigned pixelKill     : 1;	//	PixelKill operation
									//		0x0: Do not kill
									//		0x1: Kill
		unsigned outputFromH0  : 1;	//	Output registers
									//		0x0: H0
									//		0x1: R0
		unsigned padding3      : 2;
		unsigned depthReplace  : 3;	//	Depth replacement
									//		0x0: Do not replace
									//		0x7: Replace
		unsigned padding4      : 1;

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateShaderControl;

	typedef struct CellDbgRsxBundleStateReduceDstColor
	{
		unsigned padding : 31;
		unsigned enable  : 1;	//	Blend optimization
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateReduceDstColor;

	typedef struct CellDbgRsxBundleStateShaderWindow
	{
		unsigned padding     : 12;
		unsigned pixelCenter : 4;	//	Pixel center of fragment program
									//		CELL_GCM_WINDOW_PIXEL_CENTER_HALF: Half-integer
									//		CELL_GCM_WINDOW_PIXEL_CENTER_INTEGER: Integer
		unsigned origin      : 4;	//	Origin of fragment program
									//		CELL_GCM_WINDOW_ORIGIN_TOP: Upper left corner
									//		CELL_GCM_WINDOW_ORIGIN_BOTTOM: Lower left corner
		unsigned height      : 12;	//	Height of surface (0 - 4095)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateShaderWindow;

	typedef struct CellDbgRsxBundleStateDepthBoundsMin
	{
		unsigned zmin : 32;	//	Depth boundary minimum (float)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateDepthBoundsMin;

	typedef struct CellDbgRsxBundleStateDepthBoundsMax
	{
		unsigned zmax : 32;	//	Depth boundary maximum (float)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateDepthBoundsMax;

	typedef struct CellDbgRsxBundleStateVertexAttribInputMask
	{
		unsigned padding : 16;
		unsigned ATTR15  : 1;	//	Texture coordinate 7 (float4)
								//	Binormal vector (float4)
		unsigned ATTR14  : 1;	//	Texture coordinate 6 (float4)
								//	Tangent vector (float4)
		unsigned ATTR13  : 1;	//	Texture coordinate 5 (float4)
		unsigned ATTR12  : 1;	//	Texture coordinate 4 (float4)
		unsigned ATTR11  : 1;	//	Texture coordinate 3 (float4)
		unsigned ATTR10  : 1;	//	Texture coordinate 2 (float4)
		unsigned ATTR09  : 1;	//	Texture coordinate 1 (float4)
		unsigned ATTR08  : 1;	//	Texture coordinate 0 (float4)
		unsigned ATTR07  : 1;	//	Skinning palette index (float4)
		unsigned ATTR06  : 1;	//	Point size (float)
		unsigned ATTR05  : 1;	//	Fog coordinate (float)
		unsigned ATTR04  : 1;	//	Secondary color (float4)
		unsigned ATTR03  : 1;	//	Color (float4)
		unsigned ATTR02  : 1;	//	Normal (float3)
		unsigned ATTR01  : 1;	//	Vertex weight (float)
		unsigned ATTR00  : 1;	//	Vertex (float4) 

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexAttribInputMask;

	typedef struct CellDbgRsxBundleStateVertexAttribOutputMask
	{
		unsigned padding   : 10;
		unsigned TEXCOORD9 : 1;	//	Texture coordinate 9
		unsigned TEXCOORD8 : 1;	//	Texture coordinate 8
		unsigned TEXCOORD7 : 1;	//	Texture coordinate 7
		unsigned TEXCOORD6 : 1;	//	Texture coordinate 6
		unsigned TEXCOORD5 : 1;	//	Texture coordinate 5
		unsigned TEXCOORD4 : 1;	//	Texture coordinate 4
		unsigned TEXCOORD3 : 1;	//	Texture coordinate 3
		unsigned TEXCOORD2 : 1;	//	Texture coordinate 2
		unsigned TEXCOORD1 : 1;	//	Texture coordinate 1
		unsigned TEXCOORD0 : 1;	//	Texture coordinate 0
		unsigned CLP5      : 1;	//	User clip plane 5
		unsigned CLP4      : 1;	//	User clip plane 4
		unsigned CLP3      : 1;	//	User clip plane 3
		unsigned CLP2      : 1;	//	User clip plane 2
		unsigned CLP1      : 1;	//	User clip plane 1
		unsigned CLP0      : 1;	//	User clip plane 0
		unsigned PSIZE     : 1;	//	Point size
		unsigned FOG       : 1;	//	Fog
		unsigned BCOL1     : 1;	//	Back specular color
		unsigned BCOL0     : 1;	//	Back diffuse color
		unsigned COLOR1    : 1;	//	Front specular color
		unsigned COLOR0    : 1;	//	Front diffuse color

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexAttribOutputMask;

	typedef struct CellDbgRsxBundleStateTexCoordControl
	{
		struct {
			unsigned padding           : 24;
			unsigned texCoordsCentroid : 4;		//	texCoordsCentroid: Centroid sampling
												//		0x0: Disabled 
												//		0x1: Enabled
			unsigned texCoords2D       : 4;		//	Whether the texture coordinate is 2-D and the coordinate has perspective division performed
												//		0x0: Not 2-D
												//		0x1: 2-D
		} data[10];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTexCoordControl;

	typedef struct CellDbgRsxBundleStateVertexDataBaseOffset
	{
		unsigned baseOffset : 32;	//	Base offset for vertex attribute data

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexDataBaseOffset;

	typedef struct CellDbgRsxBundleStateVertexDataBaseIndex
	{
		unsigned baseIndex : 32;	//	Base index for vertex attribute data

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexDataBaseIndex;

	typedef struct CellDbgRsxBundleStateTransformTimeout
	{
		unsigned padding       : 8;
		unsigned registerCount : 8;		//	Number of registers used
										//		0x20: 32 or fewer registers
										//		0x30: More than 32 registers
		unsigned count         : 16;	//	Always 0xFFFF

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTransformTimeout;

	typedef struct CellDbgRsxBundleStateShaderPacker
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	sRGB conversion in fragment program
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateShaderPacker;

	typedef struct CellDbgRsxBundleStateTransformBranchBits
	{
		unsigned branchBits : 32;	//	Values of b0, b1, ... b31 (1 = true, 0 = false)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTransformBranchBits;

	typedef struct CellDbgRsxBundleStateColorMask
	{
		unsigned AlphaWriteEnable : 8;	//	Write to alpha value
		unsigned RedWriteEnable   : 8;	//	Write to R value
		unsigned GreenWriteEnable : 8;	//	Write to G value
		unsigned BlueWriteEnable  : 8;	//	Write to B value

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateColorMask;

	typedef struct CellDbgRsxBundleStateTransformProgramLoad
	{
		unsigned padding  :  8;
		unsigned loadSlot : 24;	//	Current slot number

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTransformProgramLoad;

	typedef struct CellDbgRsxBundleStateTransformConstantLoad
	{
		unsigned padding  :  8;
		unsigned loadSlot : 24;	//	Constants slot number of load destination

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTransformConstantLoad;

	typedef struct CellDbgRsxBundleStateTextureOffset
	{
		struct {
			unsigned offset : 32;	//	Texture data offset(from the base address of main memory and of local memory)
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureOffset;

	typedef struct CellDbgRsxBundleStateTextureFormat
	{
		struct {
			unsigned padding    : 12;
			unsigned mipmap     :  4;	//	Texture mipmap level
			unsigned format     :  8;	//	Format = (1) Color format | (2) Swizzle flag | (3) Normalization flag
			unsigned dimension  :  4;	//	Texture dimension
										//		CELL_GCM_TEXTURE_DIMENSION_1: 1-D texture
										//		CELL_GCM_TEXTURE_DIMENSION_2: 2-D texture
										//		CELL_GCM_TEXTURE_DIMENSION_3: 3-D texture
			unsigned bordermode :  1;	//	Referencing a texture border
										//		CELL_GCM_TEXTURE_BORDER_TEXTURE: use a texel value
										//		CELL_GCM_TEXTURE_BORDER_COLOR: use a color value
			unsigned cubemap    :  1;	//	Cube mapping
										//		CELL_GCM_FALSE: Disabled
										//		CELL_GCM_TRUE: Enabled
			unsigned location   :  2;	//	Texture location
										//		0x1: Local memory 
										//		0x2: Main memory
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureFormat;

	typedef struct CellDbgRsxBundleStateTextureAddress
	{
		struct {
			unsigned zfunc         : 4;	//	Test method for depth textures
			unsigned padding       : 4;	
			unsigned gamma_a       : 1;	//	sRGB reverse conversion (reverse gamma correction)
			unsigned gamma_b       : 1;	//	[8:8] Invalid alpha [9:9] Blue [10:10] Green [11:11] Red
			unsigned gamma_g       : 1;	//		0x0: Do not execute conversion
			unsigned gamma_r       : 1;	//		0x1: Execute conversion
			unsigned wrapr         : 4;	//	Adjustment when the R coordinate exceeds the texture size
			unsigned unsignedRemap : 4;	//	Normalization method for the read texel values
			unsigned wrapt         : 4;	//	Adjustment when the T coordinate exceeds the texture size
			unsigned anisoBias     : 4;	//	Anisotropic filter calculation bias
			unsigned wraps         : 4;	//	Adjustment when the S coordinate exceeds the texture size
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureAddress;

	typedef struct CellDbgRsxBundleStateTextureControl0
	{
		struct {
			unsigned enable    :  1;	//	Texture sampler
										//		CELL_GCM_FALSE: Disabled
										//		CELL_GCM_TRUE: Enabled
			unsigned minLod    : 12;	//	Minimum LOD of texture reduction filter (0.0 - 12.0)
										//		12-bit unsigned fixed-point value [4-bit integer, 8-bit fraction]
			unsigned maxLod    : 12;	//	Maximum LOD of texture reduction filter (0.0 - 12.0)
										//		12-bit unsigned fixed-point value [4-bit integer, 8-bit fraction]
			unsigned maxAniso  :  3;	//	Maximum sample level of anisotropic filter
			unsigned padding0  :  1;
			unsigned AlphaKill :  1;	//	Enable/Disable AlphaKill
										//		CELL_GCM_FALSE: Disabled
										//		CELL_GCM_TRUE: Enabled
			unsigned padding1  :  2;
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureControl0;

	typedef struct CellDbgRsxBundleStateTextureControl1
	{
		struct {
			unsigned padding    : 12;
			unsigned RemapOrder :  4;	//	Vector map with 2 input elements
			unsigned OutB       :  2;	//	Output color element B
			unsigned OutG       :  2;	//	Output color element G
			unsigned OutR       :  2;	//	Output color element R
			unsigned OutA       :  2;	//	Output color element A
			unsigned InB        :  2;	//	Input color element B
			unsigned InG        :  2;	//	Input color element G
			unsigned InR        :  2;	//	Input color element R
			unsigned InA        :  2;	//	Input color element A
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureControl1;

	typedef struct CellDbgRsxBundleStateTextureControl2
	{
		struct {
			unsigned padding0 : 24;
			unsigned aniso    :  1;		//	LOD calculation method for anisotropic filter
										//		CELL_GCM_TEXTURE_ANISO_LOW: Partial differential of the texture coordinates of 2 axes
										//		CELL_GCM_TEXTURE_ANISO_HIGH: Partial differential of the texture coordinates of 4 axes
			unsigned iso      :  1;		//	LOD calculation method for isotropic filter
										//		CELL_GCM_TEXTURE_ISO_LOW: Partial differential of the texture coordinates of 2 axes
										//		CELL_GCM_TEXTURE_ISO_HIGH: Partial differential of the texture coordinates of 4 axes
			unsigned padding1 :  1;
			unsigned slope    :  5;		//	Slope value for optimizing mipmapping
										//		0x00: 1
										//		0x01: 1.125
										//			(... increment by 0.125)
										//		0x08: 2
										//		0x09: 2.25
										//			(... increment by 0.25)
										//		0x10: 4
										//		0x11: 4.5
										//			(... increment by 0.5)
										//		0x18: 8
										//		0x19: 9
										//			(... increment by 1.0)
										//		0x1f: 15
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureControl2;

	typedef struct CellDbgRsxBundleStateTextureControl3
	{
		struct {
			unsigned padding0 :  2;
			unsigned depth    : 10;		//	Depth of texture (1 - 512)
			unsigned padding1 :  2;
			unsigned pitch    : 18;		//	Pitch size of texture(Texture width multiplied by number of bytes/texel)
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureControl3;

	typedef struct CellDbgRsxBundleStateTextureFilter
	{
		struct {
			unsigned BSigned :  1;	//	Handle B component as complement of 2
			unsigned GSigned :  1;	//	Handle G component as complement of 2
			unsigned RSigned :  1;	//	Handle R component as complement of 2
			unsigned ASigned :  1;	//	Handle A component as complement of 2
			unsigned mag     :  4;	//	Filter type for texture enlargement (details below)
			unsigned min     :  8;	//	Filter type for texture reduction (details below)
			unsigned conv    :  3;	//	Convolution filter formula
									//		CELL_GCM_TEXTURE_CONVOLUTION_QUINCUNX
									//		CELL_GCM_TEXTURE_CONVOLUTION_GAUSSIAN
									//		CELL_GCM_TEXTURE_CONVOLUTION_QUINCUNX_ALT
			unsigned bias    : 13;	//	Bias value for mipmap level in texture reductions
									//	13-bit signed fixed-point value [1-bit sign, 4-bit integer, 8-bit fraction]
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureFilter;

	typedef struct CellDbgRsxBundleStateTextureImageRect
	{
		struct {
			unsigned width  : 16;	//	Width of RECT
			unsigned height : 16;	//	Height of RECT
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureImageRect;

	typedef struct CellDbgRsxBundleStateTextureBorderColor
	{
		struct {
			unsigned color : 32;	//	Color value of border (A8R8G8B8)
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTextureBorderColor;

	typedef struct CellDbgRsxBundleStateVertexTextureOffset
	{
		struct {
			unsigned offset : 32;	//	Offset from base address of buffer
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureOffset;

	typedef struct CellDbgRsxBundleStateVertexTextureFormat
	{
		struct {
			unsigned padding0  : 12;
			unsigned mipmap    :  4;	//	Texture mipmap level
			unsigned format    :  8;	//	Texture format
										//		0xbb: CELL_GCM_TEXTURE_W32_Z32_Y32_X32_FLOAT| CELL_GCM_TEXTURE_LN| CELL_GCM_TEXTURE_NR
										//	Linear format, normalized texture coordinates, four 32-bit float values
										//		0xbc: CELL_GCM_TEXTURE_X32_FLOAT| CELL_GCM_TEXTURE_LN| CELL_GCM_TEXTURE_NR
										//	Linear format, normalized texture coordinates, one 32-bit float value
			unsigned dimension :  4;	//	Texture dimension
										//		CELL_GCM_TEXTURE_DIMENSION_1: 1-D texture
										//		CELL_GCM_TEXTURE_DIMENSION_2: 2-D texture
			unsigned padding1  :  2;
			unsigned location  :  2;	//	Texture location
										//		0x1: Local memory
										//		0x2: Main memory
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureFormat;

	typedef struct CellDbgRsxBundleStateVertexTextureAddress
	{
		struct {
			unsigned padding0 : 20;
			unsigned wrapt    :  4;		//	Adjustment when the T coordinate exceeds the texture size
			unsigned padding1 :  4;
			unsigned wraps    :  4;		//	Adjustment when the S coordinate exceeds the texture size
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureAddress;

	typedef struct CellDbgRsxBundleStateVertexTextureControl0
	{
		struct {
			unsigned enable  :  1;	//	Vertex texture sampler
									//		CELL_GCM_FALSE: Disabled
									//		CELL_GCM_TRUE: Enabled
			unsigned minLod  : 12;	//	Minimum LOD of reduction filter (0.0 - 12.0)
									//	12-bit unsigned fixed-point value [4-bit integer, 8-bit fraction]
			unsigned maxLod  : 12;	//	Maximum LOD of reduction filter (0.0 - 12.0)
									//	12-bit unsigned fixed-point value [4-bit integer, 8-bit fraction]
			unsigned padding :  7;
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureControl0;

	typedef struct CellDbgRsxBundleStateVertexTextureControl3
	{
		struct {
			unsigned padding : 14;
			unsigned pitch   : 18;	//	Pitch width of texture
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureControl3;

	typedef struct CellDbgRsxBundleStateVertexTextureFilter
	{
		struct {
			unsigned padding : 19;
			unsigned bias    : 13;	//	Bias value of mipmap level
									//	13-bit signed fixed-point value [1-bit sign, 4-bit integer, 8-bit fraction]
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureFilter;

	typedef struct CellDbgRsxBundleStateVertexTextureImageRect
	{
		struct {
			unsigned width  : 16;	//	Width of RECT
			unsigned height : 16;	//	Height of RECT
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureImageRect;

	typedef struct CellDbgRsxBundleStateVertexTextureBorderColor
	{
		struct {
			unsigned color : 32;	//	Color value of texture border (A8R8G8B8)
		} data[4];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexTextureBorderColor;

	typedef struct CellDbgRsxBundleStateAnisoSpread
	{
		struct {
			unsigned padding0             : 8;
			unsigned vReduceSamplesEnable : 4;	//	Vertical space enabled/disabled setting
			unsigned vSpacingSelect       : 4;	//	Values specifying a vertical space
			unsigned hReduceSamplesEnable : 4;	//	Horizontal space enabled/disabled setting
			unsigned hSpacingSelect       : 4;	//	Values specifying a horizontal space
			unsigned reduceSamplesEnable  : 4;	//	Diagonal space enabled/disabled setting
			unsigned spacingSelect        : 4;	//	Values specifying a diagonal space
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateAnisoSpread;

	typedef struct CellDbgRsxBundleStateAlphaFunc
	{
		unsigned af : 32;	//	Symbol constant to select the alpha comparison function

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateAlphaFunc;

	typedef struct CellDbgRsxBundleStateAlphaRef
	{
		unsigned ref : 32;	//	Value to compare with input alpha value

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateAlphaRef;

	typedef struct CellDbgRsxBundleStateAlphaTestEnable
	{
		unsigned enable : 32;	//	Alpha test
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateAlphaTestEnable;

	typedef struct CellDbgRsxBundleStateDepthTestEnable
	{
		unsigned enable : 32;	//	Depth test
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateDepthTestEnable;

	typedef struct CellDbgRsxBundleStateDepthFunc
	{
		unsigned zf : 32;	//	Symbol constant to select the depth comparison function

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateDepthFunc;

	typedef struct CellDbgRsxBundleStateDitherEnable
	{
		unsigned enable : 32;	//	Dithering
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateDitherEnable;

	typedef struct CellDbgRsxBundleStateDepthMask
	{
		unsigned enable : 32;	//	Writes to depth buffer
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateDepthMask;

	typedef struct CellDbgRsxBundleStateStencilTestEnable
	{
		unsigned enable : 32;	//	Stencil test
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilTestEnable;

	typedef struct CellDbgRsxBundleStateTwoSidedStencilTestEnable
	{
		unsigned enable : 32;	//	Two-sided stencil test
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTwoSidedStencilTestEnable;

	typedef struct CellDbgRsxBundleStateStencilFunc
	{
		unsigned func : 32;		//	Function to use in the stencil test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilFunc;

	typedef struct CellDbgRsxBundleStateStencilFuncRef
	{
		unsigned ref : 32;		//	Stencil test reference value

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilFuncRef;

	typedef struct CellDbgRsxBundleStateStencilFuncMask
	{
		unsigned mask : 32;		//	Stencil test mask value

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilFuncMask;

	typedef struct CellDbgRsxBundleStateStencilMask
	{
		unsigned sm : 32;		//	Bit mask for controlling writes to the stencil plane

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilMask;

	typedef struct CellDbgRsxBundleStateStencilOpFail
	{
		unsigned fail : 32;		//	Stencil processing after failing the stencil test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilOpFail;

	typedef struct CellDbgRsxBundleStateStencilOpZfail
	{
		unsigned depthFail : 32;	//	Stencil processing after failing the depth test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilOpZfail;

	typedef struct CellDbgRsxBundleStateStencilOpZpass
	{
		unsigned depthPass : 32;	//	Stencil processing after passing both the stencil test and the depth test

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateStencilOpZpass;

	typedef struct CellDbgRsxBundleStateShadeMode
	{
		unsigned sm : 32;	//	Shading method
							//		CELL_GCM_FLAT: Flat shading
							//		CELL_GCM_SMOOTH: Smooth shading

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateShadeMode;

	typedef struct CellDbgRsxBundleStatePointSpriteControl
	{
		unsigned padding0  : 14;
		unsigned texcoord9 :  1;	//	Output point sprite coordinates for TEX0 - TEX9
		unsigned texcoord8 :  1;
		unsigned texcoord7 :  1;
		unsigned texcoord6 :  1;
		unsigned texcoord5 :  1;
		unsigned texcoord4 :  1;
		unsigned texcoord3 :  1;
		unsigned texcoord2 :  1;
		unsigned texcoord1 :  1;
		unsigned texcoord0 :  1;
		unsigned padding1  :  5;
		unsigned rmode     :  2;	//	R value when rendering point primitives
									//		CELL_GCM_POINT_SPRITE_RMODE_ZERO: Always 0
									//		CELL_GCM_POINT_SPRITE_RMODE_FROM_R: Input R value
									//		CELL_GCM_POINT_SPRITE_RMODE_FROM_S: Input S value
		unsigned enable    :  1;	//	Point sprite
									//		CELL_GCM_FALSE: Disabled
									//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePointSpriteControl;

	typedef struct CellDbgRsxBundleStateFogMode
	{
		unsigned mode : 32;		//	Fog interpolation mode
								//		CELL_GCM_FOG_MODE_LINEAR: Use LINEAR mode
								//		CELL_GCM_FOG_MODE_EXP: Use EXPONENTIAL mode 
								//		CELL_GCM_FOG_MODE_EXP2: Use EXPONENTIAL2 mode 
								//		CELL_GCM_FOG_MODE_EXP_ABS: Use EXPONENTIAL absolute mode
								//		CELL_GCM_FOG_MODE_EXP2_ABS: Use EXPONENTIAL2 absolute mode
								//		CELL_GCM_FOG_MODE_LINEAR_ABS: Use LINEAR absolute mode

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateFogMode;

	typedef struct CellDbgRsxBundleStateTransformProgramStart
	{
		unsigned startSlot : 32;	//	Vertex shader instruction slot number

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTransformProgramStart;

	typedef struct CellDbgRsxBundleStateSurfaceFormat
	{
		unsigned height      : 8;	//	log2 of the height
		unsigned width       : 8;	//	log2 of the width
		unsigned antialias   : 4;	//	Multisampling mode
		unsigned type        : 4;	//	Swizzle rendering for the render target
		unsigned depthFormat : 3;	//	Depth buffer and stencil buffer format
		unsigned colorFormat : 5;	//	Color buffer format

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceFormat;

	typedef struct CellDbgRsxBundleStateSurfaceColorAoffset
	{
		unsigned colorOffset : 32;	//	Offset of color buffer (render target 0)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceColorAoffset;

	typedef struct CellDbgRsxBundleStateSurfaceColorBoffset
	{
		unsigned colorOffset : 32;	//	Offset of color buffer (render target 1)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceColorBoffset;

	typedef struct CellDbgRsxBundleStateSurfaceColorCoffset
	{
		unsigned colorOffset : 32;	//	Offset of color buffer (render target 2)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceColorCoffset;

	typedef struct CellDbgRsxBundleStateSurfaceColorDoffset
	{
		unsigned colorOffset : 32;	//	Offset of color buffer (render target 3)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceColorDoffset;

	typedef struct CellDbgRsxBundleStateSurfacePitchA
	{
		unsigned padding    : 15;
		unsigned colorPitch : 17;	//	Pitch size of color buffer (render target 0)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfacePitchA;

	typedef struct CellDbgRsxBundleStateSurfacePitchB
	{
		unsigned padding    : 15;
		unsigned colorPitch : 17;	//	Pitch size of color buffer (render target 1)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfacePitchB;

	typedef struct CellDbgRsxBundleStateSurfacePitchC
	{
		unsigned padding    : 15;
		unsigned colorPitch : 17;	//	Pitch size of color buffer (render target 2)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfacePitchC;

	typedef struct CellDbgRsxBundleStateSurfacePitchD
	{
		unsigned padding    : 15;
		unsigned colorPitch : 17;	//	Pitch size of color buffer (render target 3)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfacePitchD;

	typedef struct CellDbgRsxBundleStateSurfaceZetaOffset
	{
		unsigned depthOffset : 32;	//	Offset of depth buffer

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfaceZetaOffset;

	typedef struct CellDbgRsxBundleStateSurfacePitchZ
	{
		unsigned padding    : 15;
		unsigned depthPitch : 17;	//	Pitch size of depth buffer

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateSurfacePitchZ;

	typedef struct CellDbgRsxBundleStateColorMaskMrt
	{
		unsigned padding0               : 16;
		unsigned BlueWriteEnableB_MRT3  :  1;	//	Write to color element (blue) of MRT3
		unsigned GreenWriteEnableB_MRT3 :  1;	//	Write to color element (green) of MRT3
		unsigned RedWriteEnableB_MRT3   :  1;	//	Write to color element (red) of MRT3
		unsigned AlphaWriteEnableB_MRT3 :  1;	//	Write to alpha element of MRT3
		unsigned BlueWriteEnableB_MRT2  :  1;	//	Write to color element (blue) of MRT2
		unsigned GreenWriteEnableB_MRT2 :  1;	//	Write to color element (green) of MRT2
		unsigned RedWriteEnableB_MRT2   :  1;	//	Write to color element (red) of MRT2
		unsigned AlphaWriteEnableB_MRT2 :  1;	//	Write to alpha element of MRT2
		unsigned BlueWriteEnableB_MRT1  :  1;	//	Write to color element (blue) of MRT1
		unsigned GreenWriteEnableB_MRT1 :  1;	//	Write to color element (green) of MRT1
		unsigned RedWriteEnableB_MRT1   :  1;	//	Write to color element (red) of MRT1
		unsigned AlphaWriteEnableB_MRT1 :  1;	//	Write to alpha element of MRT1
		unsigned padding1               :  4;

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateColorMaskMrt;

	typedef struct CellDbgRsxBundleStateVertexDataArrayFormat
	{
		struct {
			unsigned padding : 16;
			unsigned Stride  :  8;	//	Byte offset between consecutive vertices (0 - 255)
			unsigned Size    :  4;	//	Number of coordinates per vertex (0 - 4)
			unsigned Type    :  4;	//	Vertex array datatype
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexDataArrayFormat;

	typedef struct CellDbgRsxBundleStateVertexDataArrayOffset
	{
		struct {
			unsigned location :  1;		//	Local memory or main memory
										//		0x0: Local memory
										//		0x1: Main memory
			unsigned offset   : 31;		//	Offset value of the vertex attribute data
		} data[16];

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateVertexDataArrayOffset;

	typedef struct CellDbgRsxBundleStateContextDmaColorA
	{
		unsigned padding  : 31;
		unsigned location :  1;		//	Location of color buffer 0
									//		0x0: Local memory
									//		0x1: Main memory

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateContextDmaColorA;

	typedef struct CellDbgRsxBundleStateContextDmaColorB
	{
		unsigned padding  : 31;
		unsigned location :  1;		//	Location of color buffer 1
									//		0x0: Local memory
									//		0x1: Main memory

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateContextDmaColorB;

	typedef struct CellDbgRsxBundleStateContextDmaColorC
	{
		unsigned padding  : 31;
		unsigned location :  1;		//	Location of color buffer 2
									//		0x0: Local memory
									//		0x1: Main memory

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateContextDmaColorC;

	typedef struct CellDbgRsxBundleStateContextDmaColorD
	{
		unsigned padding  : 31;
		unsigned location :  1;		//	Location of color buffer 3
									//		0x0: Local memory
									//		0x1: Main memory

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateContextDmaColorD;

	typedef struct CellDbgRsxBundleStateContextDmaZeta
	{
		unsigned padding  : 31;
		unsigned location :  1;		//	Location of the depth buffer
									//		0x0: Local memory
									//		0x1: Main memory

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateContextDmaZeta;

	typedef struct CellDbgRsxBundleStateFrontFace
	{
		unsigned dir : 32;	//	The face of the polygon to use as the front

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateFrontFace;

	typedef struct CellDbgRsxBundleStateCullFace
	{
		unsigned cfm : 32;	//	The polygon face to cull (front or back)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateCullFace;

	typedef struct CellDbgRsxBundleStateCullFaceEnable
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	Face culling
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateCullFaceEnable;

	typedef struct CellDbgRsxBundleStateLineWidth
	{
		unsigned padding : 23;
		unsigned width   :  9;	//	Line width for rasterization
								//	(Fixed-point format with 6-bit integer and 3-bit decimal)

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateLineWidth;

	typedef struct CellDbgRsxBundleStateLineSmoothEnable
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	Antialiasing for lines
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateLineSmoothEnable;

	typedef struct CellDbgRsxBundleStatePolyOffsetFillEnable
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	Polygon offset fill
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePolyOffsetFillEnable;

	typedef struct CellDbgRsxBundleStatePolyOffsetLineEnable
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	Polygon offset for lines
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePolyOffsetLineEnable;

	typedef struct CellDbgRsxBundleStatePolySmoothEnable
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	Antialiasing for polygons
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStatePolySmoothEnable;

	typedef struct CellDbgRsxBundleStateFrontPolygonMode
	{
		unsigned mode : 32;		//	Rendering mode

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateFrontPolygonMode;

	typedef struct CellDbgRsxBundleStateBackPolygonMode
	{
		unsigned mode : 32;		//	Rendering mode

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateBackPolygonMode;

	typedef struct CellDbgRsxBundleStateTwoSideLightEn
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	Two-sided coloring
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateTwoSideLightEn;

	typedef struct CellDbgRsxBundleStateControl0
	{
		unsigned padding0 : 19;
		unsigned format   :  1;		//	Depth format
		unsigned padding1 : 12;

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateControl0;

	typedef struct CellDbgRsxBundleStateDepthBoundsTestEnable
	{
		unsigned padding : 31;
		unsigned enable  :  1;	//	Depth boundary test
								//		CELL_GCM_FALSE: Disabled
								//		CELL_GCM_TRUE: Enabled

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateDepthBoundsTestEnable;

	typedef struct CellDbgRsxBundleStateFrequencyDividerOperation
	{
		unsigned padding  : 16;
		unsigned ATTR15   :  1;	//	Calculation method for vertex attribute 15
		unsigned ATTR14   :  1;	//	Calculation method for vertex attribute 14
		unsigned ATTR13   :  1;	//	Calculation method for vertex attribute 13
		unsigned ATTR12   :  1;	//	Calculation method for vertex attribute 12
		unsigned ATTR11   :  1;	//	Calculation method for vertex attribute 11
		unsigned ATTR10   :  1;	//	Calculation method for vertex attribute 10
		unsigned ATTR09   :  1;	//	Calculation method for vertex attribute  9
		unsigned ATTR08   :  1;	//	Calculation method for vertex attribute  8
		unsigned ATTR07   :  1;	//	Calculation method for vertex attribute  7
		unsigned ATTR06   :  1;	//	Calculation method for vertex attribute  6
		unsigned ATTR05   :  1;	//	Calculation method for vertex attribute  5
		unsigned ATTR04   :  1;	//	Calculation method for vertex attribute  4
		unsigned ATTR03   :  1;	//	Calculation method for vertex attribute  3
		unsigned ATTR02   :  1;	//	Calculation method for vertex attribute  2
		unsigned ATTR01   :  1;	//	Calculation method for vertex attribute  1
		unsigned ATTR00   :  1;	//	Calculation method for vertex attribute  0

	} __attribute__ ((aligned(4))) CellDbgRsxBundleStateFrequencyDividerOperation;


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif