/* SCE CONFIDENTIAL
 PlayStation(R)3 Programmer Tool Runtime Library 475.001
 *
 *      Copyright (C) 2011 Sony Computer Entertainment Inc.
 *                        All Rights Reserved.
 *
 *
 */

#ifndef __CELL_LIBATRAC3MULTI_H__
#define __CELL_LIBATRAC3MULTI_H__

#include <stdint.h>
#include <cell/error.h>
#include <cell/spurs.h>

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif

/*J エラーコードの定義       (FACLITY=CELL_ERROR_FACILITY_CODEC 0x061)  */
/*J                           libatrac3multi : 0x80610b00 - 0x80610bff) */
/*E Error code definition    (FACLITY=CELL_ERROR_FACILITY_CODEC 0x061)  */
/*E                           libatrac3multi : 0x80610b00 - 0x80610bff) */
#define CELL_ATRACMULTI_ERROR_FACILITY_ATRAC              CELL_ERROR_CAST(0x80610b00)

#define CELL_ATRACMULTI_OK                                CELL_ERROR_CAST(0x00000000)

#define CELL_ATRACMULTI_ERROR_API_FAIL                    CELL_ERROR_CAST(0x80610b01)

#define CELL_ATRACMULTI_ERROR_READSIZE_OVER_BUFFER        CELL_ERROR_CAST(0x80610b11)
#define CELL_ATRACMULTI_ERROR_UNKNOWN_FORMAT              CELL_ERROR_CAST(0x80610b12)
#define CELL_ATRACMULTI_ERROR_READSIZE_IS_TOO_SMALL       CELL_ERROR_CAST(0x80610b13)
#define CELL_ATRACMULTI_ERROR_ILLEGAL_SAMPLING_RATE       CELL_ERROR_CAST(0x80610b14)
#define CELL_ATRACMULTI_ERROR_ILLEGAL_DATA                CELL_ERROR_CAST(0x80610b15)

#define CELL_ATRACMULTI_ERROR_NO_DECODER                  CELL_ERROR_CAST(0x80610b21)
#define CELL_ATRACMULTI_ERROR_UNSET_DATA                  CELL_ERROR_CAST(0x80610b22)
#define CELL_ATRACMULTI_ERROR_DECODER_WAS_CREATED         CELL_ERROR_CAST(0x80610b23)

#define CELL_ATRACMULTI_ERROR_ALLDATA_WAS_DECODED         CELL_ERROR_CAST(0x80610b31)
#define CELL_ATRACMULTI_ERROR_NODATA_IN_BUFFER            CELL_ERROR_CAST(0x80610b32)
#define CELL_ATRACMULTI_ERROR_NOT_ALIGNED_OUT_BUFFER      CELL_ERROR_CAST(0x80610b33)
#define CELL_ATRACMULTI_ERROR_NEED_SECOND_BUFFER          CELL_ERROR_CAST(0x80610b34)

#define CELL_ATRACMULTI_ERROR_ALLDATA_IS_ONMEMORY         CELL_ERROR_CAST(0x80610b41)
#define CELL_ATRACMULTI_ERROR_ADD_DATA_IS_TOO_BIG         CELL_ERROR_CAST(0x80610b42)

#define CELL_ATRACMULTI_ERROR_NONEED_SECOND_BUFFER        CELL_ERROR_CAST(0x80610b51)

#define CELL_ATRACMULTI_ERROR_UNSET_LOOP_NUM              CELL_ERROR_CAST(0x80610b61)

#define CELL_ATRACMULTI_ERROR_ILLEGAL_SAMPLE              CELL_ERROR_CAST(0x80610b71)
#define CELL_ATRACMULTI_ERROR_ILLEGAL_RESET_BYTE          CELL_ERROR_CAST(0x80610b72)

#define CELL_ATRACMULTI_ERROR_ILLEGAL_PPU_THREAD_PRIORITY CELL_ERROR_CAST(0x80610b81)
#define CELL_ATRACMULTI_ERROR_ILLEGAL_SPU_THREAD_PRIORITY CELL_ERROR_CAST(0x80610b82)

#define CELL_ATRACMULTI_ERROR_API_PARAMETER               CELL_ERROR_CAST(0x80610b91)

/*J 特殊な状態におけるデコードできる残りフレーム数 */
/*E Remain Frame for some special cases */
#define CELL_ATRACMULTI_ALLDATA_IS_ON_MEMORY             (-1)
#define CELL_ATRACMULTI_NONLOOP_STREAM_DATA_IS_ON_MEMORY (-2)
#define CELL_ATRACMULTI_LOOP_STREAM_DATA_IS_ON_MEMORY    (-3)

#define CELL_ATRACMULTI_HANDLE_SIZE (512)

typedef struct {
	uint8_t uiWorkMem[CELL_ATRACMULTI_HANDLE_SIZE];
} CellAtracMultiHandle __attribute__((aligned(8)));

typedef struct {
	uint8_t  *pucWriteAddr;
	uint32_t uiWritableByte;
	uint32_t uiMinWriteByte;
	uint32_t uiReadPosition;
} CellAtracMultiBufferInfo;


typedef struct {
	CellSpurs  *pSpurs;
	uint8_t    priority[8];
} CellAtracMultiExtRes;


/*J ワークメモリサイズの取得関数 */
int32_t cellAtracMultiSetDataAndGetMemSize(CellAtracMultiHandle *pHandle,
										  uint8_t         *pucBufferAddr,
										  uint32_t        uiReadByte,
										  uint32_t        uiBufferByte,
										  uint32_t        uiOutputChNum,
										  int32_t         *piTrackArray,
										  uint32_t        *puiWorkMemByte);

/*J デコーダの作成及び解放 */
int32_t cellAtracMultiCreateDecoder(CellAtracMultiHandle *pHandle,
								   uint8_t         *pucWorkMem,
								   uint32_t          uiPpuThreadPriority,
								   uint32_t          uiSpuThreadPriority);

int32_t cellAtracMultiCreateDecoderExt(CellAtracMultiHandle *pHandle,
									  uint8_t         *pucWorkMem,
									  uint32_t        uiPpuThreadPriority,
									  CellAtracMultiExtRes *pExtRes);

int32_t cellAtracMultiDeleteDecoder(CellAtracMultiHandle *pHandle);

/*J デコードを行なう */
int32_t cellAtracMultiDecode(CellAtracMultiHandle *pHandle,
							float           *pfOutAddr,
							uint32_t        *puiSamples,
							uint32_t        *puifinishflag,
							int32_t         *piRemainframe);

/*J データの継ぎ足しを行なう */
int32_t cellAtracMultiAddStreamData(CellAtracMultiHandle *pHandle,
								   uint32_t  uiAddByte);

/*J セカンドバッファ関連API */
int32_t cellAtracMultiGetSecondBufferInfo(CellAtracMultiHandle *pHandle,
										 uint32_t  *puiReadPosition,
										 uint32_t  *puiDataByte);

int32_t cellAtracMultiSetSecondBuffer(CellAtracMultiHandle *pHandle,
									 uint8_t         *pucSecondBufferAddr,
									 uint32_t        uiSecondBufferByte);

/*J 情報取得系API */
int32_t cellAtracMultiGetRemainFrame(CellAtracMultiHandle *pHandle,
									int32_t   *piRemainframe);

int32_t cellAtracMultiGetVacantSize(CellAtracMultiHandle *pHandle,
								   uint32_t   *puiVacantSize);

int32_t cellAtracMultiGetStreamDataInfo(CellAtracMultiHandle *pHandle,
									   uint8_t    **ppucWritePointer,
									   uint32_t    *puiWritableByte,
									   uint32_t    *puiReadPosition);

int32_t cellAtracMultiGetChannel(CellAtracMultiHandle *pHandle,
								uint32_t        *puiChannel);

int32_t cellAtracMultiGetMaxSample(CellAtracMultiHandle *pHandle,
								  uint32_t        *puiMaxSample);

int32_t cellAtracMultiGetNextSample(CellAtracMultiHandle *pHandle,
								   uint32_t        *puiNextSample);

int32_t cellAtracMultiGetSoundInfo(CellAtracMultiHandle *pHandle,
								  int32_t         *piEndSample,
								  int32_t         *piLoopStartSample,
								  int32_t         *piLoopEndSample);

int32_t cellAtracMultiGetNextDecodePosition(CellAtracMultiHandle *pHandle,
										   uint32_t *puiSamplePosition);

int32_t cellAtracMultiGetBitrate(CellAtracMultiHandle *pHandle,
								uint32_t	*puiBitrate);

int32_t cellAtracMultiGetLoopInfo(CellAtracMultiHandle *pHandle,
								 int32_t         *piLoopNum,
								 uint32_t        *puiLoopStatus);

int32_t cellAtracMultiIsSecondBufferNeeded(CellAtracMultiHandle *pHandle);

int32_t cellAtracMultiGetTrackArray(CellAtracMultiHandle *pHandle,
									int32_t *piTrackArray);

/*J ループ回数変更API */
int32_t cellAtracMultiSetLoopNum(CellAtracMultiHandle *pHandle, 
								int32_t  iLoopNum);

/*J 再生位置変更API */
int32_t cellAtracMultiGetBufferInfoForResetting(CellAtracMultiHandle     *pHandle, 
											   uint32_t            uiSample,
											   CellAtracMultiBufferInfo *pBufferInfo);

int32_t cellAtracMultiResetPlayPosition(CellAtracMultiHandle *pHandle, 
									   uint32_t        uiSample,
									   uint32_t        uiWriteByte,
									   int32_t         *piTrackArray
								   );

/*J 内部エラー取得関数 */
int32_t cellAtracMultiGetInternalErrorInfo(CellAtracMultiHandle *pHandle, 
										  int32_t *piResult);

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif

#endif /* __CELL_LIBATRAC3MULTI_H__ */
