/* SCE CONFIDENTIAL
 PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef	 __CELL_ADEC_M4AAC_H__
#define	 __CELL_ADEC_M4AAC_H__

#if defined(__cplusplus)
extern "C" {
#endif /* defined(__cplusplus) */


/* MPEG4 AAC Parameters */
typedef struct {
	/* ADIF header presents : 0 */
	/* ADTS header presents : 1 */
	/* raw data block only  : 2 */
	uint32_t	configNumber;

	union {
		/* config number is 0 */
		struct {
			/* 0 is first program */
			uint32_t programNumber;
		} adifConfig;

		/* config number is 2 */
		struct {
			/* 96000 :  0 */
			/* 88200 :  1 */
			/* 64000 :  2 */
			/* 48000 :  3 */
			/* 44100 :  4 */
			/* 32000 :  5 */
			/* 24000 :  6 */
			/* 22050 :  7 */
			/* 16000 :  8 */
			/* 12000 :  9 */
			/* 11025 : 10 */
			/*  8000 : 11 */
			uint32_t samplingFreqIndex;

			/* LC profile   : 1 */
			uint32_t profile;
		} rawDataBlockConfig;
	} configInfo;

	uint32_t enableDownmix; /* !0 is eanble downmix for 5.1/5.0/3.1/3.0 to 2(.0) */
} CellAdecParamM4Aac;

/* MPEG4 AAC BSI */
typedef struct {
	uint32_t samplingFreq;			/* Sampling frequency [Hz] */
	uint32_t numberOfChannels;		/* number of total channels */

	uint32_t numberOfFrontChannels;
	uint32_t numberOfFrontMonoChannels;
	uint32_t numberOfSideChannels;
	uint32_t numberOfBackChannels;
	uint32_t numberOfLfeChannels;

	uint32_t enableSBR;
	uint32_t SBRUpsamplingFactor;

	uint32_t isBsiValid;

	uint32_t configNumber;

	union {
		struct {
			uint32_t copyrightIdPresent;
			char copyrightId[9];
			uint32_t originalCopy;
			uint32_t home;
			uint32_t bitstreamType;
			uint32_t bitrate;
			uint32_t numberOfProgramConfigElements;
			uint32_t bufferFullness;
		} adif;

		struct {
			uint32_t id;
			uint32_t layer;
			uint32_t protectionAbsent;
			uint32_t profile;
			uint32_t samplingFreqIndex;
			uint32_t privateBit;
			uint32_t channelConfiguration;
			uint32_t originalCopy;
			uint32_t home;
			uint32_t copyrightIdBit;
			uint32_t copyrightIdStart;
			uint32_t frameLength;
			uint32_t bufferFullness;
			uint32_t numberOfRawDataBlocks;
			uint32_t crcCheck;
		} adts;
	} bsi;

	struct {
		uint32_t matrixMixdownPresent;
		uint32_t mixdownIndex;
		uint32_t pseudoSurroundEnable;
	} matrixMixdown;

	uint32_t reserved;
} __attribute__((aligned(16))) CellAdecM4AacInfo;


/* Core Adapter */
#define CELL_ADEC_ERROR_M4AAC_FATAL								CELL_ERROR_CAST(0x80612401)
#define CELL_ADEC_ERROR_M4AAC_SEQ								CELL_ERROR_CAST(0x80612402)
#define CELL_ADEC_ERROR_M4AAC_ARG								CELL_ERROR_CAST(0x80612403)
#define CELL_ADEC_ERROR_M4AAC_BUSY								CELL_ERROR_CAST(0x80612404)
#define CELL_ADEC_ERROR_M4AAC_EMPTY								CELL_ERROR_CAST(0x80612405)
#define CELL_ADEC_ERROR_M4AAC_BUFFER_OVERFLOW					CELL_ERROR_CAST(0x80612406)
#define CELL_ADEC_ERROR_M4AAC_END_OF_BITSTREAM					CELL_ERROR_CAST(0x80612407)

/* Core */
#define CELL_ADEC_ERROR_M4AAC_CH_CONFIG_INCONSISTENCY			CELL_ERROR_CAST(0x80612410)
#define CELL_ADEC_ERROR_M4AAC_NO_CH_DEFAULT_POS					CELL_ERROR_CAST(0x80612411)
#define CELL_ADEC_ERROR_M4AAC_INVALID_CH_POS					CELL_ERROR_CAST(0x80612412)
#define CELL_ADEC_ERROR_M4AAC_UNANTICIPATED_COUPLING_CH			CELL_ERROR_CAST(0x80612413)
#define CELL_ADEC_ERROR_M4AAC_INVALID_LAYER_ID					CELL_ERROR_CAST(0x80612414)
#define CELL_ADEC_ERROR_M4AAC_ADTS_SYNCWORD_ERROR				CELL_ERROR_CAST(0x80612415)
#define CELL_ADEC_ERROR_M4AAC_INVALID_ADTS_ID					CELL_ERROR_CAST(0x80612416)
#define CELL_ADEC_ERROR_M4AAC_CH_CHANGED						CELL_ERROR_CAST(0x80612417)
#define CELL_ADEC_ERROR_M4AAC_SAMPLING_FREQ_CHANGED				CELL_ERROR_CAST(0x80612418)
#define CELL_ADEC_ERROR_M4AAC_WRONG_SBR_CH						CELL_ERROR_CAST(0x80612419)
#define CELL_ADEC_ERROR_M4AAC_WRONG_SCALE_FACTOR				CELL_ERROR_CAST(0x8061241a)
#define CELL_ADEC_ERROR_M4AAC_INVALID_BOOKS						CELL_ERROR_CAST(0x8061241b)
#define CELL_ADEC_ERROR_M4AAC_INVALID_SECTION_DATA				CELL_ERROR_CAST(0x8061241c)
#define CELL_ADEC_ERROR_M4AAC_PULSE_IS_NOT_LONG					CELL_ERROR_CAST(0x8061241d)
#define CELL_ADEC_ERROR_M4AAC_GC_IS_NOT_SUPPORTED				CELL_ERROR_CAST(0x8061241e)
#define CELL_ADEC_ERROR_M4AAC_INVALID_ELEMENT_ID				CELL_ERROR_CAST(0x8061241f)
#define CELL_ADEC_ERROR_M4AAC_NO_CH_CONFIG						CELL_ERROR_CAST(0x80612420)
#define CELL_ADEC_ERROR_M4AAC_UNEXPECTED_OVERLAP_CRC			CELL_ERROR_CAST(0x80612421)
#define CELL_ADEC_ERROR_M4AAC_CRC_BUFFER_EXCEEDED				CELL_ERROR_CAST(0x80612422)
#define CELL_ADEC_ERROR_M4AAC_INVALID_CRC						CELL_ERROR_CAST(0x80612423)
#define CELL_ADEC_ERROR_M4AAC_BAD_WINDOW_CODE					CELL_ERROR_CAST(0x80612424)
#define CELL_ADEC_ERROR_M4AAC_INVALID_ADIF_HEADER_ID			CELL_ERROR_CAST(0x80612425)
#define CELL_ADEC_ERROR_M4AAC_NOT_SUPPORTED_PROFILE				CELL_ERROR_CAST(0x80612426)
#define CELL_ADEC_ERROR_M4AAC_PROG_NUMBER_NOT_FOUND				CELL_ERROR_CAST(0x80612427)
#define CELL_ADEC_ERROR_M4AAC_INVALID_SAMP_RATE_INDEX			CELL_ERROR_CAST(0x80612428)
#define CELL_ADEC_ERROR_M4AAC_UNANTICIPATED_CH_CONFIG			CELL_ERROR_CAST(0x80612429)
#define CELL_ADEC_ERROR_M4AAC_PULSE_OVERFLOWED					CELL_ERROR_CAST(0x8061242a)
#define CELL_ADEC_ERROR_M4AAC_CAN_NOT_UNPACK_INDEX				CELL_ERROR_CAST(0x8061242b)
#define CELL_ADEC_ERROR_M4AAC_DEINTERLEAVE_FAILED				CELL_ERROR_CAST(0x8061242c)
#define CELL_ADEC_ERROR_M4AAC_CALC_BAND_OFFSET_FAILED			CELL_ERROR_CAST(0x8061242d)
#define CELL_ADEC_ERROR_M4AAC_GET_SCALE_FACTOR_FAILED			CELL_ERROR_CAST(0x8061242e)
#define CELL_ADEC_ERROR_M4AAC_GET_CC_GAIN_FAILED				CELL_ERROR_CAST(0x8061242f)
#define CELL_ADEC_ERROR_M4AAC_MIX_COUPLING_CH_FAILED			CELL_ERROR_CAST(0x80612430)
#define CELL_ADEC_ERROR_M4AAC_GROUP_IS_INVALID					CELL_ERROR_CAST(0x80612431)
#define CELL_ADEC_ERROR_M4AAC_PREDICT_FAILED					CELL_ERROR_CAST(0x80612432)
#define CELL_ADEC_ERROR_M4AAC_INVALID_PREDICT_RESET_PATTERN		CELL_ERROR_CAST(0x80612433)
#define CELL_ADEC_ERROR_M4AAC_INVALID_TNS_FRAME_INFO			CELL_ERROR_CAST(0x80612434)
#define CELL_ADEC_ERROR_M4AAC_GET_MASK_FAILED					CELL_ERROR_CAST(0x80612435)
#define CELL_ADEC_ERROR_M4AAC_GET_GROUP_FAILED					CELL_ERROR_CAST(0x80612436)
#define CELL_ADEC_ERROR_M4AAC_GET_LPFLAG_FAILED					CELL_ERROR_CAST(0x80612437)
#define CELL_ADEC_ERROR_M4AAC_INVERSE_QUANTIZATION_FAILED		CELL_ERROR_CAST(0x80612438)
#define CELL_ADEC_ERROR_M4AAC_GET_CB_MAP_FAILED					CELL_ERROR_CAST(0x80612439)
#define CELL_ADEC_ERROR_M4AAC_GET_PULSE_FAILED					CELL_ERROR_CAST(0x8061243a)
#define CELL_ADEC_ERROR_M4AAC_MONO_MIXDOWN_ELEMENT_IS_NOT_SUPPORTED \
																CELL_ERROR_CAST(0x8061243b)
#define CELL_ADEC_ERROR_M4AAC_STEREO_MIXDOWN_ELEMENT_IS_NOT_SUPPORTED \
																CELL_ERROR_CAST(0x8061243c)

/* SBR */
#define CELL_ADEC_ERROR_M4AAC_SBR_CH_OVERFLOW					CELL_ERROR_CAST(0x80612480)
#define CELL_ADEC_ERROR_M4AAC_SBR_NOSYNCH						CELL_ERROR_CAST(0x80612481)
#define CELL_ADEC_ERROR_M4AAC_SBR_ILLEGAL_PROGRAM				CELL_ERROR_CAST(0x80612482)
#define CELL_ADEC_ERROR_M4AAC_SBR_ILLEGAL_TAG					CELL_ERROR_CAST(0x80612483)
#define CELL_ADEC_ERROR_M4AAC_SBR_ILLEGAL_CHN_CONFIG			CELL_ERROR_CAST(0x80612484)
#define CELL_ADEC_ERROR_M4AAC_SBR_ILLEGAL_SECTION				CELL_ERROR_CAST(0x80612485)
#define CELL_ADEC_ERROR_M4AAC_SBR_ILLEGAL_SCFACTORS				CELL_ERROR_CAST(0x80612486)
#define CELL_ADEC_ERROR_M4AAC_SBR_ILLEGAL_PULSE_DATA			CELL_ERROR_CAST(0x80612487)
#define CELL_ADEC_ERROR_M4AAC_SBR_MAIN_PROFILE_NOT_IMPLEMENTED	CELL_ERROR_CAST(0x80612488)
#define CELL_ADEC_ERROR_M4AAC_SBR_GC_NOT_IMPLEMENTED			CELL_ERROR_CAST(0x80612489)
#define CELL_ADEC_ERROR_M4AAC_SBR_ILLEGAL_PLUS_ELE_ID			CELL_ERROR_CAST(0x8061248a)
#define CELL_ADEC_ERROR_M4AAC_SBR_CREATE_ERROR					CELL_ERROR_CAST(0x8061248b)
#define CELL_ADEC_ERROR_M4AAC_SBR_NOT_INITIALIZED				CELL_ERROR_CAST(0x8061248c)
#define CELL_ADEC_ERROR_M4AAC_SBR_INVALID_ENVELOPE				CELL_ERROR_CAST(0x8061248d)


#if defined(__cplusplus)
}
#endif /* defined(__cplusplus) */

#endif /* __CELL_ADEC_M4AAC_H__ */
