/* SCE CONFIDENTIAL
 * PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

/* copysignf function */

#ifndef _F_COPYSIGNF_H
#define _F_COPYSIGNF_H

_FUNC_DEF(
	float,
	f_copysignf,
	(float x, float y))
{	/* copy sign from y to x */
	  union U {
	    unsigned int s;
	    float f;
	  } ux, uy;
	  ux.f = x;
	  uy.f = y;

	ux.s = (ux.s & ~0x80000000) | (uy.s & 0x80000000);
	return (ux.f);
}

#endif /** _F_COPYSIGNF_H **/
