// SCE CONFIDENTIAL
// PlayStation(R)3 Programmer Tool Runtime Library 475.001
// Copyright (C) 2010 Sony Computer Entertainment Inc.
// All Rights Reserved.

#ifndef __CELL_SPURS_TYPES_CPP_H__
#define __CELL_SPURS_TYPES_CPP_H__ 1

#include <cell/spurs/types.h>

#ifdef __PPU__
#include <cell/spurs/control.h>
#include <cell/spurs/exception.h>
#include <cell/spurs/lv2_event_queue.h>
#include <cell/spurs/system_workload.h>

namespace cell {
	namespace Spurs {
		inline int SpursAttribute::initialize(SpursAttribute* attribute, int nSpus, int spuPriority, int ppuPriority,  bool exitIfNoWork)
		{
			return cellSpursAttributeInitialize(attribute, nSpus, spuPriority, ppuPriority, exitIfNoWork);
		}
		inline int SpursAttribute::setMemoryContainerForSpuThread(sys_memory_container_t container)
		{
			return cellSpursAttributeSetMemoryContainerForSpuThread(this, container);
		}
		inline int SpursAttribute::setNamePrefix(const char* name,size_t size)
		{
			return cellSpursAttributeSetNamePrefix(this, name, size);
		}
		inline int SpursAttribute::setSpuThreadGroupType(int type)
		{
			return cellSpursAttributeSetSpuThreadGroupType(this, type);
		}
		inline int SpursAttribute::enableSpuPrintfIfAvailable()
		{
			return cellSpursAttributeEnableSpuPrintfIfAvailable(this);
		}
		inline int SpursAttribute::enableSystemWorkload(const uint8_t priority[8], unsigned int maxSpu, const bool isPreemptible[8])
		{
			return cellSpursAttributeEnableSystemWorkload(this, priority, maxSpu, isPreemptible);
		}

		inline int Spurs::initialize(Spurs* spurs, unsigned nSpus, int spuPriority, int ppuPriority, bool exitIfNoWork)
		{
			return cellSpursInitialize(spurs,nSpus,spuPriority,ppuPriority,exitIfNoWork);
		}
		inline int Spurs::initialize(Spurs* spurs, const CellSpursAttribute* attr)
		{
			return cellSpursInitializeWithAttribute (spurs, attr);
		}
		inline int Spurs::initializeWithAttribute(Spurs* spurs, const CellSpursAttribute* attr)
		{
			return cellSpursInitializeWithAttribute (spurs, attr);
		}
		inline int Spurs::finalize()
		{
			return cellSpursFinalize(this);
		}
		inline int Spurs::wakeUp()
		{
			return cellSpursWakeUp(this);
		}
		inline int Spurs::getNumSpuThread(unsigned* nThreads)
		{
			return cellSpursGetNumSpuThread(this, nThreads);
		}
		inline int Spurs::setMaxContention(CellSpursWorkloadId wid,  unsigned int maxContention)
		{
			return cellSpursSetMaxContention(this,  wid, maxContention);
		}
		inline int Spurs::setPriorities(CellSpursWorkloadId wid, const uint8_t priorities[CELL_SPURS_MAX_SPU])
		{
			return cellSpursSetPriorities(this,  wid, priorities);
		}
		inline int Spurs::setPriority(CellSpursWorkloadId wid, unsigned int spu, unsigned int priority)
		{
			return cellSpursSetPriority(this, wid, spu, priority);
		}
		inline int Spurs::getSpuThreadId(sys_spu_thread_t* thr, unsigned* nThreads)
		{
			return cellSpursGetSpuThreadId(this, thr, nThreads);
		}
		inline int Spurs::getSpuThreadGroupId(sys_spu_thread_group_t* thr_group)
		{
			return cellSpursGetSpuThreadGroupId(this, thr_group);
		}
		inline int Spurs::getInfo(CellSpursInfo* info)
		{
			return cellSpursGetInfo(this, info);
		}
		inline int Spurs::attachLv2EventQueue(sys_event_queue_t queue, uint8_t* port, int isDynamic)
		{
			return cellSpursAttachLv2EventQueue(this, queue, port, isDynamic);
		}
		inline int Spurs::detachLv2EventQueue(uint8_t port)
		{
			return cellSpursDetachLv2EventQueue(this, port);
		}
		inline int Spurs::enableExceptionEventHandler(bool flag)
		{
			return cellSpursEnableExceptionEventHandler(this, flag);
		}
		inline int Spurs::setExceptionEventHandler(CellSpursWorkloadId id, CellSpursExceptionEventHandler eaHandler, void* arg)
		{
			return cellSpursSetExceptionEventHandler(this, id, eaHandler, arg);
		}
		inline int Spurs::unsetExceptionEventHandler(CellSpursWorkloadId id)
		{
			return cellSpursUnsetExceptionEventHandler(this, id);
		}
		inline int Spurs::setGlobalExceptionEventHandler(CellSpursGlobalExceptionEventHandler eaHandler, void* arg)
		{
			return cellSpursSetGlobalExceptionEventHandler(this, eaHandler, arg);
		}
		inline int Spurs::unsetGlobalExceptionEventHandler()
		{
			return cellSpursUnsetGlobalExceptionEventHandler(this);
		}
		inline int Spurs::setPreemptionVictimHints(const bool isPreemptible[8])
		{
			return cellSpursSetPreemptionVictimHints(this, isPreemptible);
		}

		inline int Spurs2::initialize(Spurs2* spurs2, const CellSpursAttribute* attr)
		{
			return cellSpursInitializeWithAttribute2((CellSpurs2*)spurs2, attr);
		}
		inline int Spurs2::initializeWithAttribute2(Spurs2* spurs2, const CellSpursAttribute* attr)
		{
			return cellSpursInitializeWithAttribute2((CellSpurs2*)spurs2, attr);
		}
	}
}

#endif // __PPU__
#endif // __CELL_SPURS_TYPES_CPP_H__
