/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2010 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_JOB_CONTEXT_TYPES_H__
#define __CELL_SPURS_JOB_CONTEXT_TYPES_H__

#include <stdint.h>
#include <cell/spurs/job_descriptor.h>


typedef struct CellSpursJobContext2
{
	/// input/inout buffer
	void *ioBuffer;

	/// read-only cache buffer(s)
	void *cacheBuffer[4];

	uint32_t sizeJobDescriptor:4; /// 0:64bytes,otherwise sizeJobDescriptor*128 bytes
	uint32_t pad:28;

	/// number of io buffers
	uint16_t numIoBuffer;

	/// number of cache input buffers
	uint16_t numCacheBuffer;

	/// Output buffer
	void* oBuffer;

	/// Scratch buffer
	void* sBuffer;

	/// DMA tag for this job's I/O dmas. This will be one of: {20,21}.
	/// This value identifies a single job.
	unsigned int dmaTag;

	/// Job descriptor Effective Address
	uint64_t eaJobDescriptor;

} CellSpursJobContext2;

typedef struct CellSpursJobInputDataElement
{
	uint32_t size;
	void    *pointer;
} CellSpursJobInputDataElement;

enum CellSpursJobBufOverrunErrMask {
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_RO_DATA1       = (1u<<0x0),
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_RO_DATA2       = (1u<<0x1),
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_RO_DATA3       = (1u<<0x2),
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_RO_DATA4       = (1u<<0x3),
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_INOUT          = (1u<<0x4),
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_OUT            = (1u<<0x5),
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_STACK_SCRATCH  = (1u<<0x6),
	CELL_SPURS_JOB_BUF_OVERRUN_MASK_NULL_POINTER   = (1u<<0x7)
};

#endif /* __CELL_SPURS_JOB_CONTEXT_TYPES_H__ */
