/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef __CELL_SPURS_ERROR_H__
#define __CELL_SPURS_ERROR_H__ 1

#include <cellstatus.h>
#include <cell/error.h>


#define CELL_ERROR_MINOR_FACILITY_SPURS_CORE          0x7
#define CELL_ERROR_MINOR_FACILITY_SPURS_POLICY_MODULE 0x8
#define CELL_ERROR_MINOR_FACILITY_SPURS_TASK          0x9
#define CELL_ERROR_MINOR_FACILITY_SPURS_JOB           0xA

#define CELL_ERROR_MAKE_SPURS_CORE_ERROR(id) \
	(CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_SPU, (CELL_ERROR_MINOR_FACILITY_SPURS_CORE          << 8) | (id)))

#define CELL_ERROR_MAKE_SPURS_POLICY_MODULE_ERROR(id) \
	(CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_SPU, (CELL_ERROR_MINOR_FACILITY_SPURS_POLICY_MODULE << 8) | (id)))

#define CELL_ERROR_MAKE_SPURS_TASK_ERROR(id) \
	(CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_SPU, (CELL_ERROR_MINOR_FACILITY_SPURS_TASK          << 8) | (id)))

#define CELL_ERROR_MAKE_SPURS_JOB_ERROR(id) \
	(CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_SPU, (CELL_ERROR_MINOR_FACILITY_SPURS_JOB           << 8) | (id)))



#define CELL_SPURS_CORE_ERROR_AGAIN					CELL_ERROR_CAST(0x80410701)
#define CELL_SPURS_CORE_ERROR_INVAL					CELL_ERROR_CAST(0x80410702)
#define CELL_SPURS_CORE_ERROR_NOSYS					CELL_ERROR_CAST(0x80410703)
#define CELL_SPURS_CORE_ERROR_NOMEM					CELL_ERROR_CAST(0x80410704)
#define CELL_SPURS_CORE_ERROR_SRCH					CELL_ERROR_CAST(0x80410705)
#define CELL_SPURS_CORE_ERROR_NOENT					CELL_ERROR_CAST(0x80410706)
#define CELL_SPURS_CORE_ERROR_NOEXEC				CELL_ERROR_CAST(0x80410707)
#define CELL_SPURS_CORE_ERROR_DEADLK				CELL_ERROR_CAST(0x80410708)
#define CELL_SPURS_CORE_ERROR_PERM					CELL_ERROR_CAST(0x80410709)
#define CELL_SPURS_CORE_ERROR_BUSY					CELL_ERROR_CAST(0x8041070A)
#define CELL_SPURS_CORE_ERROR_ABORT					CELL_ERROR_CAST(0x8041070C)
#define CELL_SPURS_CORE_ERROR_FAULT					CELL_ERROR_CAST(0x8041070D)
#define CELL_SPURS_CORE_ERROR_CHILD					CELL_ERROR_CAST(0x8041070E)
#define CELL_SPURS_CORE_ERROR_STAT					CELL_ERROR_CAST(0x8041070F)
#define CELL_SPURS_CORE_ERROR_ALIGN					CELL_ERROR_CAST(0x80410710)
#define CELL_SPURS_CORE_ERROR_NULL_POINTER			CELL_ERROR_CAST(0x80410711)


#define CELL_SPURS_POLICY_MODULE_ERROR_AGAIN		CELL_ERROR_CAST(0x80410801)
#define CELL_SPURS_POLICY_MODULE_ERROR_INVAL		CELL_ERROR_CAST(0x80410802)
#define CELL_SPURS_POLICY_MODULE_ERROR_NOSYS		CELL_ERROR_CAST(0x80410803)
#define CELL_SPURS_POLICY_MODULE_ERROR_NOMEM		CELL_ERROR_CAST(0x80410804)
#define CELL_SPURS_POLICY_MODULE_ERROR_SRCH			CELL_ERROR_CAST(0x80410805)
#define CELL_SPURS_POLICY_MODULE_ERROR_NOENT		CELL_ERROR_CAST(0x80410806)
#define CELL_SPURS_POLICY_MODULE_ERROR_NOEXEC		CELL_ERROR_CAST(0x80410807)
#define CELL_SPURS_POLICY_MODULE_ERROR_DEADLK		CELL_ERROR_CAST(0x80410808)
#define CELL_SPURS_POLICY_MODULE_ERROR_PERM			CELL_ERROR_CAST(0x80410809)
#define CELL_SPURS_POLICY_MODULE_ERROR_BUSY			CELL_ERROR_CAST(0x8041080A)
#define CELL_SPURS_POLICY_MODULE_ERROR_ABORT		CELL_ERROR_CAST(0x8041080C)
#define CELL_SPURS_POLICY_MODULE_ERROR_FAULT		CELL_ERROR_CAST(0x8041080D)
#define CELL_SPURS_POLICY_MODULE_ERROR_CHILD		CELL_ERROR_CAST(0x8041080E)
#define CELL_SPURS_POLICY_MODULE_ERROR_STAT			CELL_ERROR_CAST(0x8041080F)
#define CELL_SPURS_POLICY_MODULE_ERROR_ALIGN		CELL_ERROR_CAST(0x80410810)
#define CELL_SPURS_POLICY_MODULE_ERROR_NULL_POINTER	CELL_ERROR_CAST(0x80410811)


#define CELL_SPURS_TASK_ERROR_AGAIN					CELL_ERROR_CAST(0x80410901)
#define CELL_SPURS_TASK_ERROR_INVAL					CELL_ERROR_CAST(0x80410902)
#define CELL_SPURS_TASK_ERROR_NOSYS					CELL_ERROR_CAST(0x80410903)
#define CELL_SPURS_TASK_ERROR_NOMEM					CELL_ERROR_CAST(0x80410904)
#define CELL_SPURS_TASK_ERROR_SRCH					CELL_ERROR_CAST(0x80410905)
#define CELL_SPURS_TASK_ERROR_NOENT					CELL_ERROR_CAST(0x80410906)
#define CELL_SPURS_TASK_ERROR_NOEXEC				CELL_ERROR_CAST(0x80410907)
#define CELL_SPURS_TASK_ERROR_DEADLK				CELL_ERROR_CAST(0x80410908)
#define CELL_SPURS_TASK_ERROR_PERM					CELL_ERROR_CAST(0x80410909)
#define CELL_SPURS_TASK_ERROR_BUSY					CELL_ERROR_CAST(0x8041090A)
#define CELL_SPURS_TASK_ERROR_ABORT					CELL_ERROR_CAST(0x8041090C)
#define CELL_SPURS_TASK_ERROR_FAULT					CELL_ERROR_CAST(0x8041090D)
#define CELL_SPURS_TASK_ERROR_CHILD					CELL_ERROR_CAST(0x8041090E)
#define CELL_SPURS_TASK_ERROR_STAT					CELL_ERROR_CAST(0x8041090F)
#define CELL_SPURS_TASK_ERROR_ALIGN					CELL_ERROR_CAST(0x80410910)
#define CELL_SPURS_TASK_ERROR_NULL_POINTER			CELL_ERROR_CAST(0x80410911)
#define CELL_SPURS_TASK_ERROR_FATAL					CELL_ERROR_CAST(0x80410914)

#define CELL_SPURS_TASK_ERROR_SHUTDOWN				CELL_ERROR_CAST(0x80410920)

#define CELL_SPURS_JOB_ERROR_AGAIN					CELL_ERROR_CAST(0x80410A01)
#define CELL_SPURS_JOB_ERROR_INVAL					CELL_ERROR_CAST(0x80410A02)
#define CELL_SPURS_JOB_ERROR_NOSYS					CELL_ERROR_CAST(0x80410A03)
#define CELL_SPURS_JOB_ERROR_NOMEM					CELL_ERROR_CAST(0x80410A04)
#define CELL_SPURS_JOB_ERROR_SRCH					CELL_ERROR_CAST(0x80410A05)
#define CELL_SPURS_JOB_ERROR_NOENT					CELL_ERROR_CAST(0x80410A06)
#define CELL_SPURS_JOB_ERROR_NOEXEC					CELL_ERROR_CAST(0x80410A07)
#define CELL_SPURS_JOB_ERROR_DEADLK					CELL_ERROR_CAST(0x80410A08)
#define CELL_SPURS_JOB_ERROR_PERM					CELL_ERROR_CAST(0x80410A09)
#define CELL_SPURS_JOB_ERROR_BUSY					CELL_ERROR_CAST(0x80410A0A)
#define CELL_SPURS_JOB_ERROR_JOB_DESCRIPTOR			CELL_ERROR_CAST(0x80410A0B)
#define CELL_SPURS_JOB_ERROR_JOB_DESCRIPTOR_SIZE	CELL_ERROR_CAST(0x80410A0C)
#define CELL_SPURS_JOB_ERROR_FAULT					CELL_ERROR_CAST(0x80410A0D)
#define CELL_SPURS_JOB_ERROR_CHILD					CELL_ERROR_CAST(0x80410A0E)
#define CELL_SPURS_JOB_ERROR_STAT					CELL_ERROR_CAST(0x80410A0F)
#define CELL_SPURS_JOB_ERROR_ALIGN					CELL_ERROR_CAST(0x80410A10)
#define CELL_SPURS_JOB_ERROR_NULL_POINTER			CELL_ERROR_CAST(0x80410A11)
#define CELL_SPURS_JOB_ERROR_MEMORY_CORRUPTED       CELL_ERROR_CAST(0x80410A12)

#define CELL_SPURS_JOB_ERROR_MEMORY_SIZE          CELL_ERROR_CAST(0x80410A17)
#define CELL_SPURS_JOB_ERROR_UNKNOWN_COMMAND      CELL_ERROR_CAST(0x80410A18)
#define CELL_SPURS_JOB_ERROR_JOBLIST_ALIGNMENT    CELL_ERROR_CAST(0x80410A19)
#define CELL_SPURS_JOB_ERROR_JOB_ALIGNMENT        CELL_ERROR_CAST(0x80410A1a)
#define CELL_SPURS_JOB_ERROR_CALL_OVERFLOW        CELL_ERROR_CAST(0x80410A1b)
#define CELL_SPURS_JOB_ERROR_ABORT                CELL_ERROR_CAST(0x80410A1c)
#define CELL_SPURS_JOB_ERROR_DMALIST_ELEMENT      CELL_ERROR_CAST(0x80410A1d)
#define CELL_SPURS_JOB_ERROR_NUM_CACHE            CELL_ERROR_CAST(0x80410A1e)
#define CELL_SPURS_JOB_ERROR_INVALID_BINARY       CELL_ERROR_CAST(0x80410A1f)

#endif /* __CELL_SPURS_ERROR_H__ */

/*
 * Local Variables:
 * mode: C
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
