/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2011 Sony Computer Entertainment Inc., Sony Corporation
* All Rights Reserved.
*/

#ifndef __CELL_FACE_FACE_H__
#define __CELL_FACE_FACE_H__ 1

#include <stdint.h>

#define CELL_FACE_DETECT_NUM_MAX	512
#define CELL_FACE_IMG_WIDTH_MAX		2048

typedef struct CellFaceDetectionResult {
	float		faceX;
	float		faceY;
	float		faceW;
	float		faceH;
	float		faceRoll;
	float		facePitch;
	float		faceYaw;
	uint8_t		padding[4];
	uint32_t	angleLabel;
	int32_t		score;
	int32_t		averageScore;
	uint32_t	numDetect;
} __attribute__((aligned(16))) CellFaceDetectionResult;

typedef struct CellFaceDetectionParam {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaDetectionDict;		/* cellFaceDetectionGetDictEa(); */
	uint64_t	eaFaceResult;			/* (CellFaceDetectionResult*) */
	uint64_t	eaOptParamMultiSpu;		/* (CellFaceOptParamMultiSpu*) */
	uint64_t	eaOptParamLocalSearch;	/* (CellFaceOptParamLocalSearch*) */
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	uint32_t	minFaceSize;
	uint32_t	maxFaceSize;
	uint32_t	xScanStep;
	uint32_t	yScanStep;
	float		scalingStep;
	float		detectionThreshold;
	uint32_t	maxNumResult;
	uint8_t		padding[8];
} __attribute__((aligned(16))) CellFaceDetectionParam;

typedef struct CellFaceDetectionResultData {
	uint64_t	eaFaceResult;			/* (CellFaceDetectionResult*) */
	int32_t		numFace;
	uint8_t		padding[4];
} __attribute__((aligned(16))) CellFaceDetectionResultData;

typedef struct CellFaceOptParamMultiSpu {
	uint32_t	xScanStart;
	uint32_t	yScanStart;
	uint32_t	storeOverlap;
	uint8_t		padding[4];
} __attribute__((aligned(16))) CellFaceOptParamMultiSpu;

#define CELL_FACE_LOCAL_NUM_MAX			8

typedef struct CellFaceOptParamLocalSearch {
	uint64_t	eaLocalData;			/* (CellFaceDetectionResultData*) */
	uint32_t	numLocal;
	float		scanFaceSizeMin;
	float		scanFaceSizeMax;
	uint32_t	scanFaceMarginX;
	uint32_t	scanFaceMarginY;
	uint8_t		padding[4];
} __attribute__((aligned(16))) CellFaceOptParamLocalSearch;

#define CELL_FACE_MERGE_NUM_MAX			16

typedef struct CellFaceMergeResultParam {
	uint64_t	eaMergeData;			/* (CellFaceDetectionResultData*) */
	uint64_t	eaFaceResult;			/* (CellFaceDetectionResult*) */
	uint32_t	numMerge;
	uint32_t	maxNumResult;
	uint8_t		padding[8];
} __attribute__((aligned(16))) CellFaceMergeResultParam;

/* eye nose mouth */
#define CELL_FACE_PARTS_NUM_MAX			4 /* depend on dictionary */
#define CELL_FACE_PARTS_ID_UNDEF		0
#define CELL_FACE_PARTS_ID_R_EYE_CENTER	1
#define CELL_FACE_PARTS_ID_L_EYE_CENTER	2
#define CELL_FACE_PARTS_ID_NOSE_CENTER	3
#define CELL_FACE_PARTS_ID_MOUTH_CENTER	4

/* array index of eye nose mouth */
#define CELL_FACE_PARTS_R_EYE_CENTER_INDEX	0
#define CELL_FACE_PARTS_L_EYE_CENTER_INDEX	1
#define CELL_FACE_PARTS_NOSE_CENTER_INDEX	2
#define CELL_FACE_PARTS_MOUTH_CENTER_INDEX	3

/* all parts */
#define CELL_FACE_ALL_PARTS_NUM_MAX		55 /* depend on dictionary */
#define CELL_FACE_PARTS_ID_ALL_BASE		100
#define CELL_FACE_PARTS_ID_ALL_00		(CELL_FACE_PARTS_ID_ALL_BASE+0)
#define CELL_FACE_PARTS_ID_ALL_01		(CELL_FACE_PARTS_ID_ALL_BASE+1)
#define CELL_FACE_PARTS_ID_ALL_02		(CELL_FACE_PARTS_ID_ALL_BASE+2)
#define CELL_FACE_PARTS_ID_ALL_03		(CELL_FACE_PARTS_ID_ALL_BASE+3)
#define CELL_FACE_PARTS_ID_ALL_04		(CELL_FACE_PARTS_ID_ALL_BASE+4)
#define CELL_FACE_PARTS_ID_ALL_05		(CELL_FACE_PARTS_ID_ALL_BASE+5)
#define CELL_FACE_PARTS_ID_ALL_06		(CELL_FACE_PARTS_ID_ALL_BASE+6)
#define CELL_FACE_PARTS_ID_ALL_07		(CELL_FACE_PARTS_ID_ALL_BASE+7)
#define CELL_FACE_PARTS_ID_ALL_08		(CELL_FACE_PARTS_ID_ALL_BASE+8)
#define CELL_FACE_PARTS_ID_ALL_09		(CELL_FACE_PARTS_ID_ALL_BASE+9)
#define CELL_FACE_PARTS_ID_ALL_10		(CELL_FACE_PARTS_ID_ALL_BASE+10)
#define CELL_FACE_PARTS_ID_ALL_11		(CELL_FACE_PARTS_ID_ALL_BASE+11)
#define CELL_FACE_PARTS_ID_ALL_12		(CELL_FACE_PARTS_ID_ALL_BASE+12)
#define CELL_FACE_PARTS_ID_ALL_13		(CELL_FACE_PARTS_ID_ALL_BASE+13)
#define CELL_FACE_PARTS_ID_ALL_14		(CELL_FACE_PARTS_ID_ALL_BASE+14)
#define CELL_FACE_PARTS_ID_ALL_15		(CELL_FACE_PARTS_ID_ALL_BASE+15)
#define CELL_FACE_PARTS_ID_ALL_16		(CELL_FACE_PARTS_ID_ALL_BASE+16)
#define CELL_FACE_PARTS_ID_ALL_17		(CELL_FACE_PARTS_ID_ALL_BASE+17)
#define CELL_FACE_PARTS_ID_ALL_18		(CELL_FACE_PARTS_ID_ALL_BASE+18)
#define CELL_FACE_PARTS_ID_ALL_19		(CELL_FACE_PARTS_ID_ALL_BASE+19)
#define CELL_FACE_PARTS_ID_ALL_20		(CELL_FACE_PARTS_ID_ALL_BASE+20)
#define CELL_FACE_PARTS_ID_ALL_21		(CELL_FACE_PARTS_ID_ALL_BASE+21)
#define CELL_FACE_PARTS_ID_ALL_22		(CELL_FACE_PARTS_ID_ALL_BASE+22)
#define CELL_FACE_PARTS_ID_ALL_23		(CELL_FACE_PARTS_ID_ALL_BASE+23)
#define CELL_FACE_PARTS_ID_ALL_24		(CELL_FACE_PARTS_ID_ALL_BASE+24)
#define CELL_FACE_PARTS_ID_ALL_25		(CELL_FACE_PARTS_ID_ALL_BASE+25)
#define CELL_FACE_PARTS_ID_ALL_26		(CELL_FACE_PARTS_ID_ALL_BASE+26)
#define CELL_FACE_PARTS_ID_ALL_27		(CELL_FACE_PARTS_ID_ALL_BASE+27)
#define CELL_FACE_PARTS_ID_ALL_28		(CELL_FACE_PARTS_ID_ALL_BASE+28)
#define CELL_FACE_PARTS_ID_ALL_29		(CELL_FACE_PARTS_ID_ALL_BASE+29)
#define CELL_FACE_PARTS_ID_ALL_30		(CELL_FACE_PARTS_ID_ALL_BASE+30)
#define CELL_FACE_PARTS_ID_ALL_31		(CELL_FACE_PARTS_ID_ALL_BASE+31)
#define CELL_FACE_PARTS_ID_ALL_32		(CELL_FACE_PARTS_ID_ALL_BASE+32)
#define CELL_FACE_PARTS_ID_ALL_33		(CELL_FACE_PARTS_ID_ALL_BASE+33)
#define CELL_FACE_PARTS_ID_ALL_34		(CELL_FACE_PARTS_ID_ALL_BASE+34)
#define CELL_FACE_PARTS_ID_ALL_35		(CELL_FACE_PARTS_ID_ALL_BASE+35)
#define CELL_FACE_PARTS_ID_ALL_36		(CELL_FACE_PARTS_ID_ALL_BASE+36)
#define CELL_FACE_PARTS_ID_ALL_37		(CELL_FACE_PARTS_ID_ALL_BASE+37)
//#define CELL_FACE_PARTS_ID_ALL_38		(CELL_FACE_PARTS_ID_ALL_BASE+38)	/* unsupported */
//#define CELL_FACE_PARTS_ID_ALL_39		(CELL_FACE_PARTS_ID_ALL_BASE+39)	/* unsupported */
#define CELL_FACE_PARTS_ID_ALL_40		(CELL_FACE_PARTS_ID_ALL_BASE+40)
#define CELL_FACE_PARTS_ID_ALL_41		(CELL_FACE_PARTS_ID_ALL_BASE+41)
#define CELL_FACE_PARTS_ID_ALL_42		(CELL_FACE_PARTS_ID_ALL_BASE+42)
//#define CELL_FACE_PARTS_ID_ALL_43		(CELL_FACE_PARTS_ID_ALL_BASE+43)	/* unsupported */
//#define CELL_FACE_PARTS_ID_ALL_44		(CELL_FACE_PARTS_ID_ALL_BASE+44)	/* unsupported */
#define CELL_FACE_PARTS_ID_ALL_45		(CELL_FACE_PARTS_ID_ALL_BASE+45)
#define CELL_FACE_PARTS_ID_ALL_46		(CELL_FACE_PARTS_ID_ALL_BASE+46)
#define CELL_FACE_PARTS_ID_ALL_47		(CELL_FACE_PARTS_ID_ALL_BASE+47)
#define CELL_FACE_PARTS_ID_ALL_48		(CELL_FACE_PARTS_ID_ALL_BASE+48)
#define CELL_FACE_PARTS_ID_ALL_49		(CELL_FACE_PARTS_ID_ALL_BASE+49)
#define CELL_FACE_PARTS_ID_ALL_50		(CELL_FACE_PARTS_ID_ALL_BASE+50)
#define CELL_FACE_PARTS_ID_ALL_51		(CELL_FACE_PARTS_ID_ALL_BASE+51)
#define CELL_FACE_PARTS_ID_ALL_52		(CELL_FACE_PARTS_ID_ALL_BASE+52)
#define CELL_FACE_PARTS_ID_ALL_53		(CELL_FACE_PARTS_ID_ALL_BASE+53)
#define CELL_FACE_PARTS_ID_ALL_54		(CELL_FACE_PARTS_ID_ALL_BASE+54)
#define CELL_FACE_PARTS_ID_ALL_55		(CELL_FACE_PARTS_ID_ALL_BASE+55)
#define CELL_FACE_PARTS_ID_ALL_56		(CELL_FACE_PARTS_ID_ALL_BASE+56)
#define CELL_FACE_PARTS_ID_ALL_57		(CELL_FACE_PARTS_ID_ALL_BASE+57)
#define CELL_FACE_PARTS_ID_ALL_58		(CELL_FACE_PARTS_ID_ALL_BASE+58)

/* array index of all parts */
#define CELL_FACE_PARTS_FACE_ALL_00_INDEX		0
#define CELL_FACE_PARTS_FACE_ALL_01_INDEX		1
#define CELL_FACE_PARTS_FACE_ALL_02_INDEX		2
#define CELL_FACE_PARTS_FACE_ALL_03_INDEX		3
#define CELL_FACE_PARTS_FACE_ALL_04_INDEX		4
#define CELL_FACE_PARTS_FACE_ALL_05_INDEX		5
#define CELL_FACE_PARTS_FACE_ALL_06_INDEX		6
#define CELL_FACE_PARTS_FACE_ALL_07_INDEX		7
#define CELL_FACE_PARTS_FACE_ALL_08_INDEX		8
#define CELL_FACE_PARTS_FACE_ALL_09_INDEX		9
#define CELL_FACE_PARTS_FACE_ALL_10_INDEX		10
#define CELL_FACE_PARTS_FACE_ALL_11_INDEX		11
#define CELL_FACE_PARTS_R_EYEBROW_ALL_12_INDEX	12
#define CELL_FACE_PARTS_R_EYEBROW_ALL_13_INDEX	13
#define CELL_FACE_PARTS_R_EYEBROW_ALL_14_INDEX	14
#define CELL_FACE_PARTS_R_EYE_ALL_15_INDEX		15
#define CELL_FACE_PARTS_R_EYE_ALL_16_INDEX		16
#define CELL_FACE_PARTS_R_EYE_ALL_17_INDEX		17
#define CELL_FACE_PARTS_R_EYE_ALL_18_INDEX		18
#define CELL_FACE_PARTS_R_EYE_ALL_19_INDEX		19
#define CELL_FACE_PARTS_R_EYE_ALL_20_INDEX		20
#define CELL_FACE_PARTS_R_EYE_ALL_21_INDEX		21
#define CELL_FACE_PARTS_R_EYE_ALL_22_INDEX		22
#define CELL_FACE_PARTS_R_PUPIL_ALL_23_INDEX	23
#define CELL_FACE_PARTS_L_EYEBROW_ALL_24_INDEX	24
#define CELL_FACE_PARTS_L_EYEBROW_ALL_25_INDEX	25
#define CELL_FACE_PARTS_L_EYEBROW_ALL_26_INDEX	26
#define CELL_FACE_PARTS_L_EYE_ALL_27_INDEX		27
#define CELL_FACE_PARTS_L_EYE_ALL_28_INDEX		28
#define CELL_FACE_PARTS_L_EYE_ALL_29_INDEX		29
#define CELL_FACE_PARTS_L_EYE_ALL_30_INDEX		30
#define CELL_FACE_PARTS_L_EYE_ALL_31_INDEX		31
#define CELL_FACE_PARTS_L_EYE_ALL_32_INDEX		32
#define CELL_FACE_PARTS_L_EYE_ALL_33_INDEX		33
#define CELL_FACE_PARTS_L_EYE_ALL_34_INDEX		34
#define CELL_FACE_PARTS_L_PUPIL_ALL_35_INDEX	35
#define CELL_FACE_PARTS_NOSE_ALL_36_INDEX		36
#define CELL_FACE_PARTS_NOSE_ALL_37_INDEX		37
//#define CELL_FACE_PARTS_NOSE_ALL_38_INDEX		/* unsupported */
//#define CELL_FACE_PARTS_NOSE_ALL_39_INDEX		/* unsupported */
#define CELL_FACE_PARTS_NOSTRIL_ALL_40_INDEX	38
#define CELL_FACE_PARTS_NOSTRIL_ALL_41_INDEX	39
#define CELL_FACE_PARTS_NOSTRIL_ALL_42_INDEX	40
//#define CELL_FACE_PARTS_NOSE_ALL_43_INDEX		/* unsupported */
//#define CELL_FACE_PARTS_NOSE_ALL_44_INDEX		/* unsupported */
#define CELL_FACE_PARTS_R_LIP_ALL_45_INDEX		41
#define CELL_FACE_PARTS_U_LIP_ALL_46_INDEX		42
#define CELL_FACE_PARTS_U_LIP_ALL_47_INDEX		43
#define CELL_FACE_PARTS_U_LIP_ALL_48_INDEX		44
#define CELL_FACE_PARTS_L_LIP_ALL_49_INDEX		45
#define CELL_FACE_PARTS_D_LIP_ALL_50_INDEX		46
#define CELL_FACE_PARTS_D_LIP_ALL_51_INDEX		47
#define CELL_FACE_PARTS_D_LIP_ALL_52_INDEX		48
#define CELL_FACE_PARTS_UC_LIP_ALL_53_INDEX		49
#define CELL_FACE_PARTS_UC_LIP_ALL_54_INDEX		50
#define CELL_FACE_PARTS_UC_LIP_ALL_55_INDEX		51
#define CELL_FACE_PARTS_DC_LIP_ALL_56_INDEX		52
#define CELL_FACE_PARTS_DC_LIP_ALL_57_INDEX		53
#define CELL_FACE_PARTS_DC_LIP_ALL_58_INDEX		54

typedef struct CellFacePartsResult {
	uint32_t	partsId;
	float		partsX;
	float		partsY;
	float		score;
} __attribute__((aligned(16))) CellFacePartsResult;

typedef struct CellFacePosition {
	float		regionX[4];
	float		regionY[4];
	float		pose[3];
	float		scale[3];
	float		shift[2];
} __attribute__((aligned(16))) CellFacePosition;

typedef struct CellFacePartsParam {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaPartsDict;		/* cellFacePartsGetDictEa(); */
	uint64_t	eaPartsResult;		/* (CellFacePartsResult*) */
	uint64_t	eaPositionResult;	/* (CellFacePosition*) */
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	float		faceX;
	float		faceY;
	float		faceW;
	float		faceH;
	float		faceRoll;
	float		facePitch;
	float		faceYaw;
} __attribute__((aligned(16))) CellFacePartsParam;

typedef struct CellFaceAllPartsParam {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaPartsDict;		/* cellFaceAllPartsGetDictEa(); */
	uint64_t	eaShapeDict;		/* reserved */
	uint64_t	eaPartsResult;		/* (CellFacePartsResult*) */
	uint64_t	eaShapeResult;		/* reserved */
	uint64_t	enablePartsBit;
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	float		faceX;
	float		faceY;
	float		faceW;
	float		faceH;
	float		faceRoll;
	float		facePitch;
	float		faceYaw;
} __attribute__((aligned(16))) CellFaceAllPartsParam;

typedef struct CellFaceAllPartsShapeParam {
	uint64_t	eaShapeDict;		/* cellFaceAllPartsGetShapeDictEa(); */
	uint64_t	eaPartsResult;		/* (CellFacePartsResult*) */
	uint64_t	eaShapeResult;		/* (CellFacePartsResult*) */
	float		faceYaw;
	uint8_t		padding[4];
} __attribute__((aligned(16))) CellFaceAllPartsShapeParam;

#define CELL_FACE_ATTRIB_NUM_MAX		8 /* depend on dictionary */
#define CELL_FACE_ATTRIB_ID_UNDEF		0
#define CELL_FACE_ATTRIB_ID_SMILE		1
#define CELL_FACE_ATTRIB_ID_REYEOPEN	2
#define CELL_FACE_ATTRIB_ID_LEYEOPEN	3
#define CELL_FACE_ATTRIB_ID_GENDER		4
#define CELL_FACE_ATTRIB_ID_ADULT		5
#define CELL_FACE_ATTRIB_ID_BABY		6
#define CELL_FACE_ATTRIB_ID_ELDER		7
#define CELL_FACE_ATTRIB_ID_GLASS		8

#define CELL_FACE_ATTRIB_SMILE_INDEX	0
#define CELL_FACE_ATTRIB_REYEOPEN_INDEX	1
#define CELL_FACE_ATTRIB_LEYEOPEN_INDEX	2
#define CELL_FACE_ATTRIB_GENDER_INDEX	3
#define CELL_FACE_ATTRIB_ADULT_INDEX	4
#define CELL_FACE_ATTRIB_BABY_INDEX		5
#define CELL_FACE_ATTRIB_ELDER_INDEX	6
#define CELL_FACE_ATTRIB_GLASS_INDEX	7

typedef struct CellFaceAttribResult {
	uint32_t	attribId;
	float		score;
	uint8_t		padding[8];
} __attribute__((aligned(16))) CellFaceAttribResult;

typedef struct CellFacePartsAttribParam {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaPartsDict;		/* cellFacePartsGetDictEa(); */
	uint64_t	eaAttribDict;		/* cellFaceAttribGetDictEa(); */
	uint64_t	eaPartsResult;		/* (CellFacePartsResult*) */
	uint64_t	eaAttribResult;		/* (CellFaceAttribResult*) */
	uint64_t	eaPositionResult;	/* (CellFacePosition*) */
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	float		faceX;
	float		faceY;
	float		faceW;
	float		faceH;
	float		faceRoll;
	float		facePitch;
	float		faceYaw;
} __attribute__((aligned(16))) CellFacePartsAttribParam;

typedef struct CellFaceAgeRange {
	uint32_t	minAge;
	uint32_t	maxAge;
	uint8_t		padding[8];
} __attribute__((aligned(16))) CellFaceAgeRange;

#define CELL_FACE_AGE_BIN_SIZE 81

typedef struct CellFaceAgeDistr {
	float		score[CELL_FACE_AGE_BIN_SIZE];
	uint32_t	numIntegrated;
} __attribute__((aligned(16))) CellFaceAgeDistr;

typedef struct CellFaceAgeRangeParam {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaAgeRangeDict;		/* cellFaceAgeRangeGetDictEa(); */
	uint64_t	eaParts;			/* (CellFacePartsResult*) */
	uint64_t	eaPosition;			/* (CellFacePosition*) */
	uint64_t	eaAgeRangeResult;	/* (CellFaceAgeRange*) */
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	float		faceX;
	float		faceY;
	float		faceW;
	float		faceH;
	float		faceRoll;
	float		facePitch;
	float		faceYaw;
} __attribute__((aligned(16))) CellFaceAgeRangeParam;

#define CELL_FACE_FEATURE_SIZE 16384

typedef struct CellFaceFeature {
	uint8_t		data[CELL_FACE_FEATURE_SIZE];
} __attribute__((aligned(16))) CellFaceFeature;

typedef struct CellFaceFeatureParam {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaPosition;			/* (CellFacePosition*) */
	uint64_t	eaFeatureResult;	/* (CellFaceFeature*) */
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	uint8_t		padding[4];
} __attribute__((aligned(16))) CellFaceFeatureParam;

typedef struct CellFaceSimilarityParam {
	uint64_t	eaFeature;			/* (CellFaceFeature*) */
	uint64_t	eaRegFeatureArray;	/* (CellFaceFeature*) */
	uint64_t	eaSimilarityDict;	/* cellFaceSimilarityGetDictEa(); */
	uint64_t	eaScoreResultArray;	/* float score[numRegFeature] */
	uint32_t	numRegFeature;
	uint32_t	strideRegFeature;	/* must be multiple of 16 */
	uint8_t		padding[8];
} __attribute__((aligned(16))) CellFaceSimilarityParam;

#define CELL_FACE_FEATURE2_SIZE 4096

typedef struct CellFaceFeature2 {
	uint8_t		data[CELL_FACE_FEATURE2_SIZE];
} __attribute__((aligned(16))) CellFaceFeature2;

typedef struct CellFaceFeature2Param {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaPosition;			/* (CellFacePosition*) */
	uint64_t	eaFeatureResult;	/* (CellFaceFeature2*) */
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	uint8_t		padding[4];
} __attribute__((aligned(16))) CellFaceFeature2Param;

typedef struct CellFaceSimilarity2Param {
	uint64_t	eaFeature;			/* (CellFaceFeature2*) */
	uint64_t	eaRegFeatureArray;	/* (CellFaceFeature2*) */
	uint64_t	eaSimilarityDict;	/* cellFaceSimilarity2GetDictEa(); */
	uint64_t	eaScoreResultArray;	/* float score[numRegFeature] */
	uint32_t	numRegFeature;
	uint32_t	strideRegFeature;	/* must be multiple of 16 */
	uint8_t		padding[8];
} __attribute__((aligned(16))) CellFaceSimilarity2Param;

#define CELL_FACE_FEATURE_LIGHT_SIZE 256

typedef struct CellFaceFeatureLight {
	uint8_t		data[CELL_FACE_FEATURE_LIGHT_SIZE];
} __attribute__((aligned(16))) CellFaceFeatureLight;

typedef struct CellFaceFeatureLightParam {
	uint64_t	eaImage;
	uint64_t	eaWorkingArea;
	uint64_t	eaFeatureDict;		/* cellFaceFeatureLightGetDictEa(); */
	uint64_t	eaFaceResult;		/* (cellFaceDetectionResult*) */
	uint64_t	eaPartsResult;		/* (CellFacePartsResult*) */
	uint64_t	eaFeatureResult;	/* (CellFaceFeatureLight*) */
	uint32_t	imageWidth;
	uint32_t	imageHeight;
	uint32_t	imageRowstride;
	uint8_t		padding[4];
} __attribute__((aligned(16))) CellFaceFeatureLightParam;

typedef struct CellFaceSimilarityLightParam {
	uint64_t	eaFeature;			/* (CellFaceFeatureLight*) */
	uint64_t	eaRegFeatureArray;	/* (CellFaceFeatureLight*) */
	uint64_t	eaScoreResultArray;	/* float score[numRegFeature] */
	uint32_t	numRegFeature;
	uint32_t	strideRegFeature;	/* must be multiple of 16 */
} __attribute__((aligned(16))) CellFaceSimilarityLightParam;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef __PPU__

uint64_t cellFaceDetectionGetDictEa(void);

uint64_t cellFaceDetection3DGetDictEa(void);

uint64_t cellFaceDetectionFrontalYaw3DGetDictEa(void);

uint64_t cellFaceDetectionWideGetDictEa(void);

uint64_t cellFaceDetectionWide2GetDictEa(void);

uint64_t cellFacePartsGetDictEa(void);

uint64_t cellFaceAllPartsGetDictEa(void);

uint64_t cellFaceAllPartsShapeGetDictEa(void);

uint64_t cellFaceAttribGetDictEa(void);

uint64_t cellFaceAttribExGetDictEa(void);

uint64_t cellFaceAgeRangeGetDictEa(void);

uint64_t cellFaceFeatureLightGetDictEa(void);

uint64_t cellFaceSimilarityGetDictEa(void);

uint64_t cellFaceSimilarity2GetDictEa(void);

int32_t cellFaceAgeRangeIntegrate(
	CellFaceAgeRange			*ageRange,
	CellFaceAgeDistr			*ageDistrAccum,
	uint32_t					*ageResult,
	uint32_t					*ageRangeMinResult,
	uint32_t					*ageRangeMaxResult
);

#endif /* __PPU__ */

#ifdef __SPU__
int32_t cellFaceDetection(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceDetection3D(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceDetectionFrontal(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceDetectionFrontal3D(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceDetectionFrontalRoll3D(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceDetectionFrontalYaw3D(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceDetectionWide(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceDetectionWide2(
	CellFaceDetectionParam		*detectParam,
	int32_t						*numFace
);

int32_t cellFaceMergeResult(
	CellFaceMergeResultParam	*mergeParam,
	int32_t						*numFace
);

int32_t cellFaceParts(
	CellFacePartsParam			*partsParam
);

int32_t cellFaceAllParts(
	CellFaceAllPartsParam		*allPartsParam
);

int32_t cellFaceAllPartsShapeConstraint(
	CellFaceAllPartsShapeParam	*shapeParam
);

int32_t cellFacePartsAttribute(
	CellFacePartsAttribParam	*partsAttribParam
);

int32_t cellFacePartsAttributeEx(
	CellFacePartsAttribParam	*partsAttribParam
);

int32_t cellFaceAgeRangeEstimate(
	CellFaceAgeRangeParam		*ageRangeParam
);

int32_t cellFaceFeature(
	CellFaceFeatureParam		*featureParam
);

int32_t cellFaceFeature2(
	CellFaceFeature2Param		*featureParam
);

int32_t cellFaceFeatureLight(
	CellFaceFeatureLightParam	*featureParam
);

int32_t cellFaceSimilarity(
	CellFaceSimilarityParam		*simParam,
	float						*maxScore,
	int32_t						*maxScoreId
);

int32_t cellFaceSimilarity2(
	CellFaceSimilarity2Param	*simParam,
	float						*maxScore,
	int32_t						*maxScoreId
);

int32_t cellFaceSimilarityLight(
	CellFaceSimilarityLightParam	*simParam,
	float							*maxScore,
	int32_t							*maxScoreId
);

int32_t cellFaceSetDmaTag(
	uint32_t					tag0,
	uint32_t					tag1,
	uint32_t					tag2,
	uint32_t					tag3
);

#endif /* __SPU__ */

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* __CELL_FACE_FACE_H__ */
