/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
 * Copyright (C) 2010 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_DMA_TYPES_H__
#define __CELL_DMA_TYPES_H__

#include <stdint.h>

#ifdef __PPU__
#ifdef __GNUC__
__extension__
#endif
typedef struct CellDmaListElement {
  uint64_t notify       :  1;
  uint64_t reserved     : 16;
  uint64_t size         : 15;
  uint64_t eal          : 32;
} CellDmaListElement;

#else /* __PPU__ */
#include <spu_mfcio.h>
typedef mfc_list_element_t CellDmaListElement;
#endif /* __PPU__ */


#endif /* CELL_DMA_H */


