/* SCE CONFIDENTIAL
PlayStation(R)3 Programmer Tool Runtime Library 475.001
* Copyright (C) 2010 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>


/*E
 * File: sample.cpp
 * Description:
 *   This source code is written for showing the usage of pad and keyboard recorder
 *
 *	Usage: sample.exe
 *	  <option>:
 *		-d <host>                 set hostname
 *		< <play data file>        playing mode
 *		> <record data file>      recording mode
 */


#include <assert.h>
#include "dtlib.h"
#include "dtlib_error.h"
#include "ctrlp.h"

#define DT_DEFAULT_TARGET_PORT     8530
#define DT_DEFAULT_TARGET_NAME     "PS3_LPAR"
#define DT_DEFAULT_NETM_ENV_NAME   "DTNETM"

#define PROTOCOL_NO     0x0310
#define PROTOCOL_PORT   0

using namespace std;
M__USING_NAMESPACE

typedef struct{
	char *target;
	char *playfilename;
	char *recfilename;
	uint32_t playfilesize;
	uint32_t playnumber;
	Deci3CtrlpPadData *playdata;
	uint32_t playsec;
	HANDLE   playtimer;
	FILE *playfp;
	FILE *recfp;
}arg_t;

int     flag = 1;
char *dt_program_name;
dtlib       deci;
arg_t       g_arg;

BOOL CALLBACK dcmp_recv( HCONNECT connH, BYTE *data, int size )
{
    printf( "dcmp_recv %d\n", size );
    return true;
}

void DumpHex(unsigned char *buf, int cnt){
	unsigned char *bp;
	int i,j,n;
	for(bp = buf, i=0; i< cnt; i+= 16, bp +=16){
		if(16 < (n = cnt - i))
			n = 16;
		printf(" 0x%04x: ", bp - buf);
		for(j = 0; j < 16 && j < n; j++)
			printf("%02x%s", bp[j],  ((j == 7)? "  ": " "));
		for(printf(" "); j < 16; j++)
			printf("   ");
		for(j = 0; j < 16 && j < n; j++)
			printf("%c", (' ' <= bp[j] && bp[j] < 0x7f)?
			bp[j]: '.');
		printf("\n");

	}
}

void DumpKBData(Deci3CtrlpKBData * p){
	printf(" %08x %04x %04x %04x", ntohl(p->arrange), ntohs(p->mkey), ntohs(p->led) , ntohs(p->keycode));
}

void DumpPadData(unsigned char*buf, int n){
	Deci3CtrlpPadData * p = (Deci3CtrlpPadData*)buf;
	for(int i=0; i<n; i++){
		uint32_t lo = ntohl( p->pad_time_lo);
		printf(" %d.%d:port 0x%x len 0x%x status 0x%x %x %x %x %x",lo/1000000, lo%1000000, p->port_no, p->len , p->port_status,  p->reserved0 , p->reserved1, p->reserved2 ,p->reserved3  );
		if(p->port_no == CTRLP_PORT_NUM_KB)
			DumpKBData((Deci3CtrlpKBData*)p);
		printf("\n");
		p++;
	}
}

int ctrlp_rec_start( HDECI hdeci){
	Deci3CtrlpRecStart res;
	res.header.code = htons(DECI3_CTRLP_CODE_REC_START);
	res.header.size = htons(sizeof(res));
	return deci.dt_send( hdeci, (BYTE *)&res, (int)sizeof(res));
}

int ctrlp_rec_stop( HDECI hdeci){
	Deci3CtrlpRecStop res;
	res.header.code = htons(DECI3_CTRLP_CODE_REC_STOP);
	res.header.size = htons(sizeof(res));
	return deci.dt_send( hdeci, (BYTE *)&res, (int)sizeof(res));
}

int ctrlp_play_start( HDECI hdeci, HANDLE timer, int sec){
	Deci3CtrlpPlayStart res;
	LARGE_INTEGER I;
	I.QuadPart = -10000000 * sec;
	if(0 == SetWaitableTimer(timer, &I, 0, NULL, NULL, false)){
		printf("Failed SetWaitableTimer() %p %x\n", timer, GetLastError());
	}
	res.header.code = htons(DECI3_CTRLP_CODE_PLAY_START);
	res.header.size = htons(sizeof(res));
	return deci.dt_send( hdeci, (BYTE *)&res, (int)sizeof(res));
}

int ctrlp_play_stop( HDECI hdeci, HANDLE timer){
	Deci3CtrlpPlayStop res;
	WaitForSingleObject(timer, INFINITE);

	res.header.code = htons(DECI3_CTRLP_CODE_PLAY_STOP);
	res.header.size = htons(sizeof(res));
	return deci.dt_send( hdeci, (BYTE *)&res, (int)sizeof(res));
}

int ctrlp_play_data( HDECI hdeci, Deci3CtrlpPadData *pdata, int n){
	Deci3CtrlpPlayData res;
	int i;
	res.header.code = htons(DECI3_CTRLP_CODE_PLAY_DATA);
	res.header.size = htons((uint16_t)(sizeof(res.header)+sizeof(Deci3CtrlpPadData)*n));
	Deci3CtrlpPadData *p = &res.data[0];
	for(i=0;i<n;i++){
		*p++= *pdata++;
	}
	return deci.dt_send( hdeci, (BYTE *)&res, (int)sizeof(res.header)+sizeof(Deci3CtrlpPadData)*n);
}


BOOL CALLBACK recv_ctrlp_func( HDECI hdeci, BYTE *data, int size, int status)
{
	static unsigned int reccount = 0;
	static unsigned int playcount = 0;
	static bool recording = false;
	static bool playing = false;

	if(status){
		return true;
	}

	Deci3CtrlpHeader* pCtrlpHeader = (Deci3CtrlpHeader*)data;
	pCtrlpHeader->code = ntohs(pCtrlpHeader->code);
	pCtrlpHeader->size = ntohs(pCtrlpHeader->size);
	switch(pCtrlpHeader->code){
	case DECI3_CTRLP_CODE_INITR:
		assert(pCtrlpHeader->size == sizeof(Deci3CtrlpInitr));
		printf("version %08x\n", ntohl(*(uint32_t*)(pCtrlpHeader+1)));
		if(g_arg.recfp){
			ctrlp_rec_start(hdeci);
			recording = true;
		}else{
			ctrlp_play_start(hdeci, g_arg.playtimer, g_arg.playsec);
			playing = true;
		}
		break;
	case DECI3_CTRLP_CODE_REC_STARTR:
		assert(pCtrlpHeader->size == sizeof(Deci3CtrlpRecStartr));
		printf("rec startr ret %08x\n", ntohl(*(uint32_t*)(pCtrlpHeader+1)));
		break;
	case DECI3_CTRLP_CODE_REC_STOPR:
		assert(pCtrlpHeader->size == sizeof(Deci3CtrlpRecStopr));
		printf("rec stopr ret %08x\n", ntohl(*(uint32_t*)(pCtrlpHeader+1)));

		if(g_arg.recfp){
			fclose(g_arg.recfp);
			g_arg.recfp = NULL;
		}
		return false;
		break;
	case DECI3_CTRLP_CODE_REC_DATAR:
		assert(pCtrlpHeader->size >= sizeof(Deci3CtrlpRecDatar));
		printf("%d : rec datar size %08x\n", reccount, pCtrlpHeader->size);
//		DumpHex((unsigned char*)(pCtrlpHeader+1), pCtrlpHeader->size-sizeof(Deci3CtrlpHeader));
		if(g_arg.recfp){
			fwrite((unsigned char*)(pCtrlpHeader+1), pCtrlpHeader->size-sizeof(Deci3CtrlpHeader), 1, g_arg.recfp);
		}
		DumpPadData((unsigned char*)(pCtrlpHeader+1), (pCtrlpHeader->size-sizeof(Deci3CtrlpHeader))/sizeof(Deci3CtrlpPadData));

		break;
	case DECI3_CTRLP_CODE_PLAY_STARTR:
		{
			uint32_t sendcount = g_arg.playnumber -  playcount;
			assert(pCtrlpHeader->size == sizeof(Deci3CtrlpPlayStartr));
			printf("play startr ret %08x\n", *(uint32_t*)(pCtrlpHeader+1));
			if(sendcount > CTRLP_PAD_MAX_DATA){
				sendcount = CTRLP_PAD_MAX_DATA;
			}
			ctrlp_play_data(hdeci, g_arg.playdata + playcount, sendcount);
			playcount += sendcount;
		}
		break;
	case DECI3_CTRLP_CODE_PLAY_STOPR:
		assert(pCtrlpHeader->size == sizeof(Deci3CtrlpPlayStopr));
		printf("play stopr ret %08x\n", *(uint32_t*)(pCtrlpHeader+1));
		playcount=0;
		reccount=0;
		if(g_arg.recfp){
			fclose(g_arg.recfp);
			g_arg.recfp = NULL;
		}
		return false;
		break;
	case DECI3_CTRLP_CODE_PLAY_DATAR:
		{
			uint32_t sendcount = g_arg.playnumber -  playcount;
			assert(pCtrlpHeader->size == sizeof(Deci3CtrlpPlayDatar));
			printf("%d:play datar ret %08x %x\n", playcount ,*(uint32_t*)(pCtrlpHeader+1),sendcount);
			if(sendcount > CTRLP_PAD_MAX_DATA){
				ctrlp_play_data(hdeci, g_arg.playdata + playcount, CTRLP_PAD_MAX_DATA);
				playcount+= CTRLP_PAD_MAX_DATA;
			}else if(sendcount > 0){
				ctrlp_play_data(hdeci, g_arg.playdata + playcount, sendcount);
				playcount+= sendcount;
			}else{
				ctrlp_play_stop(hdeci, g_arg.playtimer);
				playing = false;
			}
		}
		break;
	default:
		printf("unknown code %08x\n", pCtrlpHeader->code);
		break;
	}

	return true;
}


static int usage(int f_true){
	if(!f_true)
		return(0);
	printf("Usage: %s [<option>]...\n", dt_program_name);
	printf("  <option>:\n");
	printf("    -d <host>                 set hostname\n");
	printf("    < <play data file>        play datafile\n");
	printf("    > <record data file>      record datafile\n");
	exit(1);
	return 0;
}

static char* get_target(int argc, char**argv){
	g_arg.target = getenv(DT_DEFAULT_NETM_ENV_NAME);
	for(--argc, ++argv; 0 < argc; --argc, ++argv){
		if(!strcmp("-d", argv[0]))
			usage(--argc <= 0), g_arg.target = *++argv;
		else if(!strcmp("<", argv[0]))
			usage(--argc <= 0), g_arg.playfilename = *++argv;
		else if(!strcmp(">", argv[0]))
			usage(--argc <= 0), g_arg.recfilename = *++argv;
		else
			usage(1);
	}
	usage(0 < argc);
	usage(!g_arg.target);
	if((g_arg.playfilename == NULL && g_arg.recfilename == NULL) ||
		(g_arg.playfilename != NULL && g_arg.recfilename != NULL))
		usage(1);
	return g_arg.target;
}


int     main( int argc, char **argv )
{
    HCONNECT    hconnect;
    HDECI       hdeci;

	dt_program_name = argv[0];
	char *dt_target = get_target(argc, argv);

	if(g_arg.recfilename){
		g_arg.recfp = fopen(g_arg.recfilename, "wb");
		if(!g_arg.recfp){
			printf(" fopen error %s\n", g_arg.recfilename);
			return 1;			
		}
		printf("Hit any key to exit.\n");
	}
	
	if(g_arg.playfilename){
		//In order to check playing the last time, 
		g_arg.playfp = fopen(g_arg.playfilename, "rb");
		if(!g_arg.playfp){
			printf("fopen error %s\n", g_arg.playfilename);
			return 2;
		}
		fseek(g_arg.playfp, 0, SEEK_END);
		g_arg.playfilesize = ftell(g_arg.playfp);
		g_arg.playnumber = g_arg.playfilesize / sizeof(Deci3CtrlpPadData);
		fseek(g_arg.playfp, 0, SEEK_SET);
		g_arg.playdata = (Deci3CtrlpPadData*)malloc(g_arg.playfilesize);
		if(g_arg.playdata){
			uint32_t r = fread(g_arg.playdata, 1, g_arg.playfilesize, g_arg.playfp);
			Deci3CtrlpPadData *p = g_arg.playdata + (g_arg.playfilesize / sizeof(Deci3CtrlpPadData))-1;
			g_arg.playsec = (ntohl(p->pad_time_lo) / 1000000)+1;
		}
		fclose(g_arg.playfp);
		g_arg.playfp = NULL;
		if(g_arg.playdata == NULL){
			printf("malloc error\n");
			return 3;
		}
		g_arg.playtimer = CreateWaitableTimer(NULL, false, "timer for play");
		if(g_arg.playtimer == NULL){
			printf(" CreateWaitableTimer error %x\n", GetLastError());
		}
		printf("play data number %d\n", g_arg.playnumber );
	}

    hconnect = deci.dt_connect(dt_target, DT_DEFAULT_TARGET_PORT, dt_program_name );
	if( NULL == hconnect )
    {
        printf( "dt_connect error\n" );
        return 1;
    }
    
    deci.dt_set_dcmp_status_function( hconnect, dcmp_recv );
    
    hdeci = deci.dt_register(hconnect, PROTOCOL_NO, PROTOCOL_PORT, TARGET, DT_DEFAULT_TARGET_NAME );
    if( (HDECI)NULL == hdeci )
    {
        printf( "dt_register error\n" );
        return 2;
    }
    
    deci.dt_add_recv_function( hdeci, recv_ctrlp_func );
        
    while(flag)
    {
        HANDLE handle = deci.dt_select( hconnect, 0 );

		if(handle == NULL){
			int error = deci.dt_getlasterror();
			if(_kbhit()){
				break;
			}
			if(error == DTLIB_WAIT_TIMEOUT) { //timeout
				Sleep( 100 );
			}
			else {
				std::string msg = deci.dt_geterrormsg(error);
				if(msg.size())
					printf("%s\n", msg.c_str());
				if(error == DTLIB_SOCKET_CLOSE) // close socket
					return 0;
				else
					break;
			}
		}
    }
    
	if(g_arg.recfp){
		fclose(g_arg.recfp);
		g_arg.recfp = NULL;
	}
	if(g_arg.playtimer){
		CloseHandle(g_arg.playtimer);
		g_arg.playtimer = 0;
	}

    deci.dt_unregister(hdeci);
    deci.dt_disconnect(hconnect);
    return 0;
}

